/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFilesAction
extends BaseShowDiffAction {
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create((String)"CompareFilesAction.DiffRequest");
    public static final String LAST_USED_FILE_KEY = "two.files.diff.last.used.file";
    public static final String LAST_USED_FOLDER_KEY = "two.files.diff.last.used.folder";

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        String text2 = "Compare Files";
        if (files != null && files.length == 1) {
            text2 = "Compare With...";
        } else if (files != null && files.length == 2) {
            Type type2;
            Type type1 = CompareFilesAction.getType(files[0]);
            if (type1 != (type2 = CompareFilesAction.getType(files[1]))) {
                text2 = "Compare";
            } else {
                switch (type1) {
                    case FILE: {
                        text2 = "Compare Files";
                        break;
                    }
                    case DIRECTORY: {
                        text2 = "Compare Directories";
                        break;
                    }
                    case ARCHIVE: {
                        text2 = "Compare Archives";
                    }
                }
            }
        }
        e.getPresentation().setText(text2);
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        DiffRequest request;
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(1);
        }
        if ((request = (DiffRequest)e.getData(DIFF_REQUEST)) != null) {
            return true;
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            return false;
        }
        if (files.length == 1) {
            return CompareFilesAction.hasContent(files[0]);
        }
        if (files.length == 2) {
            return CompareFilesAction.hasContent(files[0]) && CompareFilesAction.hasContent(files[1]);
        }
        return false;
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareFilesAction.$$$reportNull$$$0(2);
        }
        Project project2 = e.getProject();
        DiffRequest diffRequest = (DiffRequest)e.getData(DIFF_REQUEST);
        if (diffRequest != null) {
            return diffRequest;
        }
        VirtualFile[] data = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (data.length == 1) {
            VirtualFile otherFile = CompareFilesAction.getOtherFile(project2, data[0]);
            if (otherFile == null || !CompareFilesAction.hasContent(otherFile)) {
                return null;
            }
            if (!data[0].isValid()) {
                return null;
            }
            return DiffRequestFactory.getInstance().createFromFiles(project2, data[0], otherFile);
        }
        return DiffRequestFactory.getInstance().createFromFiles(project2, data[0], data[1]);
    }

    @Nullable
    private static VirtualFile getOtherFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        String key2;
        FileChooserDescriptor descriptor2;
        Type type2;
        if (file2 == null) {
            CompareFilesAction.$$$reportNull$$$0(3);
        }
        if ((type2 = CompareFilesAction.getType(file2)) == Type.DIRECTORY || type2 == Type.ARCHIVE) {
            descriptor2 = new FileChooserDescriptor(false, true, true, true, true, false);
            key2 = LAST_USED_FOLDER_KEY;
        } else {
            descriptor2 = new FileChooserDescriptor(true, false, false, true, true, false);
            key2 = LAST_USED_FILE_KEY;
        }
        VirtualFile selectedFile = CompareFilesAction.getDefaultSelection(project2, key2, file2);
        VirtualFile otherFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project2, (VirtualFile)selectedFile);
        if (otherFile != null) {
            CompareFilesAction.updateDefaultSelection(project2, key2, otherFile);
        }
        return otherFile;
    }

    @NotNull
    private static VirtualFile getDefaultSelection(@Nullable Project project2, @NotNull String key2, @NotNull VirtualFile file2) {
        if (key2 == null) {
            CompareFilesAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            CompareFilesAction.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                CompareFilesAction.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }
        String path = PropertiesComponent.getInstance((Project)project2).getValue(key2);
        if (path == null) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                CompareFilesAction.$$$reportNull$$$0(7);
            }
            return virtualFile;
        }
        VirtualFile lastSelection = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile virtualFile = lastSelection != null ? lastSelection : file2;
        if (virtualFile == null) {
            CompareFilesAction.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    private static void updateDefaultSelection(@Nullable Project project2, @NotNull String key2, @NotNull VirtualFile file2) {
        if (key2 == null) {
            CompareFilesAction.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CompareFilesAction.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project2).setValue(key2, file2.getPath());
    }

    @NotNull
    private static Type getType(@Nullable VirtualFile file2) {
        if (file2 == null) {
            Type type2 = Type.FILE;
            if (type2 == null) {
                CompareFilesAction.$$$reportNull$$$0(11);
            }
            return type2;
        }
        if (file2.isDirectory()) {
            Type type3 = Type.DIRECTORY;
            if (type3 == null) {
                CompareFilesAction.$$$reportNull$$$0(12);
            }
            return type3;
        }
        if (file2.getFileType() instanceof ArchiveFileType) {
            Type type4 = Type.ARCHIVE;
            if (type4 == null) {
                CompareFilesAction.$$$reportNull$$$0(13);
            }
            return type4;
        }
        Type type5 = Type.FILE;
        if (type5 == null) {
            CompareFilesAction.$$$reportNull$$$0(14);
        }
        return type5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/CompareFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/CompareFilesAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSelection";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOtherFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSelection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Type {
        FILE,
        DIRECTORY,
        ARCHIVE;

    }
}

