/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentImpl
implements FileContent {
    @NotNull
    private final VirtualFile myFile;

    public FileDocumentContentImpl(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2) {
        if (document == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(1);
        }
        this(project2, document, file2, file2);
    }

    public FileDocumentContentImpl(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (document == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(3);
        }
        super(project2, document, file2.getFileType(), highlightFile, FileDocumentContentImpl.getSeparator(file2), file2.getCharset(), file2.getBOM() != null);
        this.myFile = file2;
    }

    @Nullable
    private static LineSeparator getSeparator(@NotNull VirtualFile file2) {
        String s;
        if (file2 == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(4);
        }
        if ((s = LoadTextUtil.detectLineSeparator(file2, true)) == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileDocumentContentImpl.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/contents/FileDocumentContentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/contents/FileDocumentContentImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSeparator";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

