/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownFileTypeDiffRequest
extends ComponentDiffRequest {
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myTitle;

    public UnknownFileTypeDiffRequest(@NotNull VirtualFile file2, @Nullable String title) {
        if (file2 == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(0);
        }
        this(file2.getName(), title);
    }

    public UnknownFileTypeDiffRequest(@NotNull String fileName, @Nullable String title) {
        if (fileName == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(1);
        }
        boolean knownFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE;
        this.myFileName = knownFileType ? null : fileName;
        this.myTitle = title;
    }

    @NotNull
    public JComponent getComponent(@NotNull DiffContext context) {
        if (context == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(2);
        }
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.setTextAlign(0);
        label.append("Can't show diff for unknown file type. ", new SimpleTextAttributes(0, UIUtil.getInactiveTextColor()));
        if (this.myFileName != null) {
            label.append("Associate", SimpleTextAttributes.LINK_ATTRIBUTES, () -> {
                FileType type2;
                if (context == null) {
                    UnknownFileTypeDiffRequest.$$$reportNull$$$0(5);
                }
                if ((type2 = FileTypeChooser.associateFileType(this.myFileName)) != null) {
                    this.onSuccess(context);
                }
            });
            LinkMouseListenerBase.installSingleTagOn(label);
        }
        DiffUtil.CenteredPanel centeredPanel = new DiffUtil.CenteredPanel((JComponent)label, JBUI.Borders.empty((int)5));
        if (centeredPanel == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(3);
        }
        return centeredPanel;
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void onSuccess(@NotNull DiffContext context) {
        if (context == null) {
            UnknownFileTypeDiffRequest.$$$reportNull$$$0(4);
        }
        if (context instanceof DiffContextEx) {
            ((DiffContextEx)context).reloadDiffRequest();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/requests/UnknownFileTypeDiffRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/requests/UnknownFileTypeDiffRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getComponent$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

