/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.fragmented.UnifiedContentPanel;
import com.intellij.diff.tools.util.base.DiffPanelBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffPanel
extends DiffPanelBase {
    private static final String GOOD_CONTENT = "GoodContent";
    private static final String LOADING_CONTENT = "LoadingContent";
    private static final String TOO_BIG_CONTENT = "TooBigContent";
    private static final String OPERATION_CANCELED_CONTENT = "OperationCanceledContent";
    private static final String ERROR_CONTENT = "ErrorContent";
    @NotNull
    private final AsyncProcessIcon.Big myBusyIcon;

    public UnifiedDiffPanel(@Nullable Project project2, @NotNull UnifiedContentPanel content, @NotNull DataProvider provider, @NotNull DiffContext context) {
        if (content == null) {
            UnifiedDiffPanel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            UnifiedDiffPanel.$$$reportNull$$$0(1);
        }
        if (context == null) {
            UnifiedDiffPanel.$$$reportNull$$$0(2);
        }
        super(project2, provider, context);
        this.myBusyIcon = new AsyncProcessIcon.Big("UnifiedDiff");
        BorderLayoutPanel centerPanel = JBUI.Panels.simplePanel((Component)content).addToTop((Component)this.myNotificationsPanel);
        this.myContentPanel.add((Component)centerPanel, GOOD_CONTENT);
        this.myContentPanel.add((Component)this.myBusyIcon, LOADING_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel("Can not calculate diff. File is too big and there are too many changes."), TOO_BIG_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel("Can not calculate diff. Operation canceled."), OPERATION_CANCELED_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel("Error"), ERROR_CONTENT);
        this.setCurrentCard(LOADING_CONTENT, false);
    }

    public void setLoadingContent() {
        this.setCurrentCard(LOADING_CONTENT);
    }

    public void setGoodContent() {
        this.setCurrentCard(GOOD_CONTENT);
    }

    public void setTooBigContent() {
        this.setCurrentCard(TOO_BIG_CONTENT);
    }

    public void setOperationCanceledContent() {
        this.setCurrentCard(OPERATION_CANCELED_CONTENT);
    }

    public void setErrorContent() {
        this.setCurrentCard(ERROR_CONTENT);
    }

    @Override
    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            UnifiedDiffPanel.$$$reportNull$$$0(3);
        }
        if (card == LOADING_CONTENT) {
            this.myBusyIcon.resume();
        } else {
            this.myBusyIcon.suspend();
        }
        super.setCurrentCard(card);
    }

    public boolean isGoodContent() {
        return this.myCurrentCard == GOOD_CONTENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "card";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentCard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

