/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDrawUtil {
    public static final int STRIPE_LAYER = 4999;
    public static final int DEFAULT_LAYER = 5997;
    public static final int INLINE_LAYER = 5998;
    public static final int LINE_MARKER_LAYER = 5999;
    public static final int LST_LINE_MARKER_LAYER = 5999;
    private static final double CTRL_PROXIMITY_X = 0.3;
    public static final LineSeparatorRenderer BORDER_LINE_RENDERER = new LineSeparatorRenderer(){

        public void drawLine(Graphics g, int x1, int x2, int y) {
            Rectangle clip = g.getClipBounds();
            x2 = clip.x + clip.width;
            g.setColor(JBColor.border());
            g.drawLine(x1, y, x2, y);
        }
    };

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        Color color = DiffDrawUtil.getDividerColor(null);
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(0);
        }
        return color;
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        Color color = DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme2) {
        Color gutterBackground;
        if (scheme2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(2);
        }
        if ((gutterBackground = scheme2.getColor(EditorColors.GUTTER_BACKGROUND)) == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        Color color = gutterBackground;
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(3);
        }
        return color;
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(4);
        }
        DiffLineSeparatorRenderer.drawConnectorLine(g, x1, x2, start1, start2, end1 - start1, scheme2);
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(5);
        }
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(6);
        }
        if (dottedLine && doubleLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
        } else if (dottedLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
        } else if (doubleLine) {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)(y + 1), (int)x2, (int)(y + 1), null, (Color)color);
        } else {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(7);
        }
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawLine(x1, start1, x2, start2);
            g.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(8);
        }
        Shape upperCurve = DiffDrawUtil.makeCurve(x1, x2, start1, start2, true);
        Shape lowerCurve = DiffDrawUtil.makeCurve(x1, x2, end1 + 1, end2 + 1, false);
        Shape lowerCurveBorder = DiffDrawUtil.makeCurve(x1, x2, end1, end2, false);
        if (fillColor != null) {
            Path2D.Double path = new Path2D.Double();
            path.append(upperCurve, true);
            path.append(lowerCurve, true);
            g.setColor(fillColor);
            g.fill(path);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.draw(upperCurve);
            g.draw(lowerCurveBorder);
        }
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    public static int lineToY(@NotNull Editor editor, int line) {
        Document document;
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(9);
        }
        if (line >= DiffUtil.getLineCount(document = editor.getDocument())) {
            int y = DiffDrawUtil.lineToY(editor, DiffUtil.getLineCount(document) - 1);
            return y + editor.getLineHeight() * (line - DiffUtil.getLineCount(document) + 1);
        }
        return editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getLineStartOffset((int)line))).y;
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull TextDiffType type2, final @Nullable Editor editor, final boolean ignored) {
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(10);
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getBackgroundColor() {
                return ignored ? type2.getIgnoredColor(editor) : type2.getColor(editor);
            }
        };
        if (textAttributes == null) {
            DiffDrawUtil.$$$reportNull$$$0(11);
        }
        return textAttributes;
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(final @NotNull TextDiffType type2, final @NotNull Editor editor) {
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(13);
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getErrorStripeColor() {
                return type2.getMarkerColor(editor);
            }
        };
        if (textAttributes == null) {
            DiffDrawUtil.$$$reportNull$$$0(14);
        }
        return textAttributes;
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type2) {
        if (highlighter == null) {
            DiffDrawUtil.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(16);
        }
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type2));
    }

    @NotNull
    private static LineSeparatorRenderer createDiffLineRenderer(final @NotNull Editor editor, final @NotNull TextDiffType type2, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(17);
        }
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(18);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(19);
        }
        LineSeparatorRenderer lineSeparatorRenderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Rectangle clip = g.getClipBounds();
                x2 = clip.x + clip.width;
                if (placement == SeparatorPlacement.TOP) {
                    ++y;
                }
                DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, x1, x2, y, type2.getColor(editor), doubleLine, resolved);
            }
        };
        if (lineSeparatorRenderer == null) {
            DiffDrawUtil.$$$reportNull$$$0(20);
        }
        return lineSeparatorRenderer;
    }

    @NotNull
    private static LineMarkerRenderer createFoldingGutterLineRenderer(final @NotNull TextDiffType type2, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(21);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(22);
        }
        LineMarkerRendererEx lineMarkerRendererEx = new LineMarkerRendererEx(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
                Graphics2D g2 = (Graphics2D)g;
                int x1 = gutter.getWhitespaceSeparatorOffset();
                int x2 = gutter.getWidth();
                int y = r.y;
                if (placement == SeparatorPlacement.BOTTOM) {
                    y += editor.getLineHeight();
                }
                DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y - 1, type2.getColor(editor), doubleLine, resolved);
            }

            @Override
            @NotNull
            public LineMarkerRendererEx.Position getPosition() {
                LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
                if (position == null) {
                    5.$$$reportNull$$$0(0);
                }
                return position;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$5", "getPosition"));
            }
        };
        if (lineMarkerRendererEx == null) {
            DiffDrawUtil.$$$reportNull$$$0(23);
        }
        return lineMarkerRendererEx;
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, @Nullable List<DiffFragment> innerFragments) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(24);
        }
        if (deleted == null) {
            DiffDrawUtil.$$$reportNull$$$0(25);
        }
        if (inserted == null) {
            DiffDrawUtil.$$$reportNull$$$0(26);
        }
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list2 = new ArrayList<RangeHighlighter>();
        if (!inserted.isEmpty() && !deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored));
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored));
        } else if (!inserted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored));
        } else if (!deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored));
        }
        if (innerFragments != null) {
            int deletedStartOffset = editor.getDocument().getLineStartOffset(deleted.start);
            int insertedStartOffset = editor.getDocument().getLineStartOffset(inserted.start);
            for (DiffFragment fragment : innerFragments) {
                int deletedWordStart = deletedStartOffset + fragment.getStartOffset1();
                int deletedWordEnd = deletedStartOffset + fragment.getEndOffset1();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, deletedWordStart, deletedWordEnd, TextDiffType.DELETED));
                int insertedWordStart = insertedStartOffset + fragment.getStartOffset2();
                int insertedWordEnd = insertedStartOffset + fragment.getEndOffset2();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, insertedWordStart, insertedWordEnd, TextDiffType.INSERTED));
            }
        }
        ArrayList<RangeHighlighter> arrayList = list2;
        if (arrayList == null) {
            DiffDrawUtil.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type2, boolean ignored) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(28);
        }
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(29);
        }
        List<RangeHighlighter> list2 = new LineHighlighterBuilder(editor, startLine, endLine, type2).withIgnored(ignored).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type2, boolean ignored, boolean resolved, boolean hideWithoutLineNumbers) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(31);
        }
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(32);
        }
        List<RangeHighlighter> list2 = new LineHighlighterBuilder(editor, startLine, endLine, type2).withIgnored(ignored).withResolved(resolved).withHideWithoutLineNumbers(hideWithoutLineNumbers).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(33);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type2) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(34);
        }
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(35);
        }
        List<RangeHighlighter> list2 = new InlineHighlighterBuilder(editor, start, end, type2).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type2) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(37);
        }
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(38);
        }
        if (line == 0) {
            List<RangeHighlighter> list2 = Collections.emptyList();
            if (list2 == null) {
                DiffDrawUtil.$$$reportNull$$$0(39);
            }
            return list2;
        }
        List<RangeHighlighter> list3 = DiffDrawUtil.createLineMarker(editor, line - 1, type2, SeparatorPlacement.BOTTOM, false, false, true);
        if (list3 == null) {
            DiffDrawUtil.$$$reportNull$$$0(40);
        }
        return list3;
    }

    @NotNull
    private static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type2, @NotNull SeparatorPlacement placement, boolean doubleLine, boolean resolved, boolean paintFoldingOutline) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(41);
        }
        if (type2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(42);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(43);
        }
        LineMarkerBuilder builder = new LineMarkerBuilder(editor, line, placement).withType(type2).withResolved(resolved).withDefaultRenderer(doubleLine);
        if (paintFoldingOutline) {
            builder.withDefaultGutterRenderer(doubleLine);
        }
        List<RangeHighlighter> list2 = builder.done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(44);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(45);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(46);
        }
        List<RangeHighlighter> list2 = new LineMarkerBuilder(editor, line, placement).withRenderer(BORDER_LINE_RENDERER).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition2) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(48);
        }
        if (condition2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(49);
        }
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, condition2);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        List<RangeHighlighter> list2 = Collections.singletonList(marker);
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(50);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 24: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 21: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 19: 
            case 22: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inserted";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerColor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerColorFromScheme";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStripeTextAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffLineRenderer";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createFoldingGutterLineRenderer";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnifiedChunkHighlighters";
                break;
            }
            case 30: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineHighlighter";
                break;
            }
            case 39: 
            case 40: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarker";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createBorderLineMarker";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineSeparatorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDividerColorFromScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawConnectorLineSeparator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "drawChunkBorderLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drawTrapezium";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "drawCurveTrapezium";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lineToY";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStripeTextAttributes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "installEmptyRangeRenderer";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDiffLineRenderer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingGutterLineRenderer";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createUnifiedChunkHighlighters";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createInlineHighlighter";
                break;
            }
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createBorderLineMarker";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createLineSeparatorHighlighter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int line;
        private boolean resolved;
        @Nullable
        private TextDiffType type;
        @Nullable
        private LineSeparatorRenderer renderer;
        @Nullable
        private LineMarkerRenderer gutterRenderer;

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
            if (editor == null) {
                LineMarkerBuilder.$$$reportNull$$$0(0);
            }
            if (placement == null) {
                LineMarkerBuilder.$$$reportNull$$$0(1);
            }
            this.resolved = false;
            this.editor = editor;
            this.line = line;
            this.placement = placement;
        }

        @NotNull
        public LineMarkerBuilder withType(@NotNull TextDiffType type2) {
            if (type2 == null) {
                LineMarkerBuilder.$$$reportNull$$$0(2);
            }
            this.type = type2;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(3);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(4);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withRenderer(@NotNull LineSeparatorRenderer renderer) {
            if (renderer == null) {
                LineMarkerBuilder.$$$reportNull$$$0(5);
            }
            this.renderer = renderer;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(6);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultRenderer(boolean doubleLine) {
            assert (this.type != null);
            this.renderer = DiffDrawUtil.createDiffLineRenderer(this.editor, this.type, this.placement, doubleLine, this.resolved);
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(7);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultGutterRenderer(boolean doubleLine) {
            assert (this.type != null);
            this.gutterRenderer = DiffDrawUtil.createFoldingGutterLineRenderer(this.type, this.placement, doubleLine, this.resolved);
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(8);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.editor.getDocument(), this.line);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
            highlighter.setLineSeparatorPlacement(this.placement);
            highlighter.setLineSeparatorRenderer(this.renderer);
            highlighter.setLineMarkerRenderer(this.gutterRenderer);
            if (this.type == null || this.resolved) {
                List<RangeHighlighter> list2 = Collections.singletonList(highlighter);
                if (list2 == null) {
                    LineMarkerBuilder.$$$reportNull$$$0(9);
                }
                return list2;
            }
            TextAttributes stripeAttributes = DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            List list3 = ContainerUtil.list((Object[])new RangeHighlighter[]{highlighter, stripeHighlighter});
            if (list3 == null) {
                LineMarkerBuilder.$$$reportNull$$$0(10);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withResolved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRenderer";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultRenderer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultGutterRenderer";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withType";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withRenderer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InlineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int start;
        private final int end;

        private InlineHighlighterBuilder(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type2) {
            if (editor == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(1);
            }
            this.editor = editor;
            this.type = type2;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            TextAttributes attributes = DiffDrawUtil.getTextAttributes(this.type, this.editor, false);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, 5998, attributes, HighlighterTargetArea.EXACT_RANGE);
            if (this.start == this.end) {
                DiffDrawUtil.installEmptyRangeRenderer(highlighter, this.type);
            }
            List<RangeHighlighter> list2 = Collections.singletonList(highlighter);
            if (list2 == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int startLine;
        private final int endLine;
        private boolean ignored;
        private boolean resolved;
        private boolean hideWithoutLineNumbers;

        private LineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type2) {
            if (editor == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(1);
            }
            this.ignored = false;
            this.resolved = false;
            this.hideWithoutLineNumbers = false;
            this.editor = editor;
            this.type = type2;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public LineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(2);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(3);
            }
            return lineHighlighterBuilder;
        }

        public LineHighlighterBuilder withHideWithoutLineNumbers(boolean hideWithoutLineNumbers) {
            this.hideWithoutLineNumbers = hideWithoutLineNumbers;
            return this;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isFirstLine = this.startLine == 0;
            boolean isLastLine = this.endLine == DiffUtil.getLineCount(this.editor.getDocument());
            TextRange offsets = DiffUtil.getLinesRange(this.editor.getDocument(), this.startLine, this.endLine);
            int start = offsets.getStartOffset();
            int end = offsets.getEndOffset();
            TextAttributes attributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getTextAttributes(this.type, this.editor, this.ignored);
            TextAttributes stripeAttributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 5997, attributes, HighlighterTargetArea.LINES_IN_RANGE);
            highlighters.add(highlighter);
            highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffLineMarkerRenderer(highlighter, this.type, this.ignored, this.resolved, this.hideWithoutLineNumbers, isEmptyRange, isFirstLine, isLastLine));
            if (isEmptyRange) {
                if (isFirstLine) {
                    highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, 0, this.type, SeparatorPlacement.TOP, true, this.resolved, false));
                } else {
                    highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.startLine - 1, this.type, SeparatorPlacement.BOTTOM, true, this.resolved, false));
                }
            } else if (this.resolved) {
                highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.startLine, this.type, SeparatorPlacement.TOP, false, this.resolved, false));
                highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.endLine - 1, this.type, SeparatorPlacement.BOTTOM, false, this.resolved, false));
            }
            if (stripeAttributes != null) {
                RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                highlighters.add(stripeHighlighter);
            }
            ArrayList<RangeHighlighter> arrayList = highlighters;
            if (arrayList == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIgnored";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withResolved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

