/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.repo.Repository;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsMultiRootBranchConfig<Repo extends Repository> {
    @NotNull
    protected final Collection<Repo> myRepositories;

    public DvcsMultiRootBranchConfig(@NotNull Collection<Repo> repositories) {
        if (repositories == null) {
            DvcsMultiRootBranchConfig.$$$reportNull$$$0(0);
        }
        this.myRepositories = repositories;
    }

    public boolean diverged() {
        return this.getCurrentBranch() == null;
    }

    @Nullable
    public String getCurrentBranch() {
        return this.getCommonName(Repository::getCurrentBranchName);
    }

    @Nullable
    public String getCommonName(@NotNull Function<Repo, String> nameSupplier) {
        if (nameSupplier == null) {
            DvcsMultiRootBranchConfig.$$$reportNull$$$0(1);
        }
        String commonBranch = null;
        for (Repository repository : this.myRepositories) {
            String branchName = nameSupplier.apply(repository);
            if (branchName == null) {
                return null;
            }
            if (commonBranch == null) {
                commonBranch = branchName;
                continue;
            }
            if (commonBranch.equals(branchName)) continue;
            return null;
        }
        return commonBranch;
    }

    @Nullable
    public Repository.State getState() {
        Repository.State commonState = null;
        for (Repository repository : this.myRepositories) {
            Repository.State state = repository.getState();
            if (commonState == null) {
                commonState = state;
                continue;
            }
            if (commonState.equals((Object)state)) continue;
            return null;
        }
        return commonState;
    }

    @NotNull
    public abstract Collection<String> getLocalBranchNames();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSupplier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/branch/DvcsMultiRootBranchConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

