/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLinkedTextComponent
extends JLabel {
    private static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
    @NotNull
    private String myTextBefore;
    @NotNull
    private String myTextAfter;
    @NotNull
    private String myHandledLink;
    @Nullable
    private final VcsLinkListener myLinkListener;
    private boolean mySelected;
    private boolean myUnderlined;
    private boolean myTransparent;

    public VcsLinkedTextComponent(@NotNull String text2, @Nullable VcsLinkListener listener2) {
        if (text2 == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(0);
        }
        Matcher aMatcher = HREF_PATTERN.matcher(text2);
        if (aMatcher.find()) {
            this.myTextBefore = text2.substring(0, aMatcher.start());
            this.myHandledLink = aMatcher.group(2);
            this.myTextAfter = text2.substring(aMatcher.end(), text2.length());
        } else {
            this.myTextBefore = text2;
            this.myHandledLink = "";
            this.myTextAfter = "";
        }
        this.myLinkListener = listener2;
    }

    public void updateLinkText(@NotNull String text2) {
        if (text2 == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(1);
        }
        this.myHandledLink = text2;
    }

    public void fireOnClick(@NotNull DefaultMutableTreeNode relatedNode, @NotNull MouseEvent event) {
        if (relatedNode == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(2);
        }
        if (event == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(3);
        }
        if (this.myLinkListener != null) {
            this.myLinkListener.hyperlinkActivated(relatedNode, event);
        }
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(4);
        }
        boolean isActive = this.mySelected || this.myUnderlined;
        SimpleTextAttributes linkTextAttributes = isActive ? SimpleTextAttributes.LINK_ATTRIBUTES : SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
        isActive = isActive || !this.myTransparent;
        SimpleTextAttributes wrappedTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded(SimpleTextAttributes.REGULAR_ATTRIBUTES, isActive);
        if (!StringUtil.isEmptyOrSpaces((String)this.myTextBefore)) {
            renderer.append(this.myTextBefore, wrappedTextAttributes);
            renderer.append(" ");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myHandledLink)) {
            renderer.append(this.myHandledLink, PushLogTreeUtil.addTransparencyIfNeeded(linkTextAttributes, isActive), (Object)this);
        }
        renderer.append(this.myTextAfter, wrappedTextAttributes);
    }

    public void setUnderlined(boolean underlined) {
        this.myUnderlined = underlined;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    public void setTransparent(boolean transparent) {
        this.myTransparent = transparent;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myTextBefore + this.myHandledLink + this.myTextAfter;
        if (string == null) {
            VcsLinkedTextComponent.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/VcsLinkedTextComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsLinkedTextComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateLinkText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fireOnClick";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

