/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.actions.StopAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopBackgroundProcessesAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    private Icon wrappee = null;

    public void update(AnActionEvent e) {
        if (this.wrappee == null) {
            this.wrappee = IconUtil.toSize((Icon)this.getTemplatePresentation().getIcon(), (int)16, (int)16);
        }
        e.getPresentation().setIcon(this.wrappee);
        e.getPresentation().setEnabled(!StopBackgroundProcessesAction.getCancellableProcesses(e.getProject()).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Component component;
        DataContext dataContext = e.getDataContext();
        Project project2 = e.getProject();
        List<StopAction.HandlerItem> handlerItems = StopBackgroundProcessesAction.getItemsList(StopBackgroundProcessesAction.getCancellableProcesses(project2));
        if (handlerItems.isEmpty()) {
            return;
        }
        JBList list2 = new JBList(handlerItems);
        list2.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<StopAction.HandlerItem>(){

            @Nullable
            public String getTextFor(StopAction.HandlerItem item) {
                return item.displayName;
            }

            @Nullable
            public Icon getIconFor(StopAction.HandlerItem item) {
                return item.icon;
            }

            public boolean hasSeparatorAboveOf(StopAction.HandlerItem item) {
                return item.hasSeparator;
            }
        }));
        JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setMovable(true).setTitle(handlerItems.size() == 1 ? "Confirm background process stop" : "Stop background process").setFilteringEnabled(o -> ((StopAction.HandlerItem)o).displayName).setItemChoosenCallback(() -> {
            List valuesList = list2.getSelectedValuesList();
            for (Object o : valuesList) {
                if (!(o instanceof StopAction.HandlerItem)) continue;
                ((StopAction.HandlerItem)o).stop();
            }
        }).setRequestFocus(true).createPopup();
        InputEvent inputEvent = e.getInputEvent();
        Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
        if (component != null && ("MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()))) {
            popup2.showUnderneathOf(component);
        } else if (project2 == null) {
            popup2.showInBestPositionFor(dataContext);
        } else {
            popup2.showCenteredInCurrentWindow(project2);
        }
    }

    @NotNull
    private static List<Pair<TaskInfo, ProgressIndicator>> getCancellableProcesses(@Nullable Project project2) {
        StatusBarEx statusBar;
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project2);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            List<Pair<TaskInfo, ProgressIndicator>> list2 = Collections.emptyList();
            if (list2 == null) {
                StopBackgroundProcessesAction.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List list3 = ContainerUtil.findAll(statusBar.getBackgroundProcesses(), pair2 -> ((TaskInfo)pair2.first).isCancellable() && !((ProgressIndicator)pair2.second).isCanceled());
        if (list3 == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(1);
        }
        return list3;
    }

    @NotNull
    private static List<StopAction.HandlerItem> getItemsList(@NotNull List<Pair<TaskInfo, ProgressIndicator>> tasks) {
        if (tasks == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(2);
        }
        ArrayList<StopAction.HandlerItem> items = new ArrayList<StopAction.HandlerItem>(tasks.size());
        for (final Pair<TaskInfo, ProgressIndicator> eachPair : tasks) {
            items.add(new StopAction.HandlerItem(((TaskInfo)eachPair.first).getTitle(), AllIcons.Process.Step_passive, false){

                @Override
                void stop() {
                    ((ProgressIndicator)eachPair.second).cancel();
                }
            });
        }
        ArrayList<StopAction.HandlerItem> arrayList = items;
        if (arrayList == null) {
            StopBackgroundProcessesAction.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/StopBackgroundProcessesAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancellableProcesses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/StopBackgroundProcessesAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

