/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.TextAccessor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseModuleValueActionListener<T extends JComponent>
implements ActionListener {
    private ComponentWithBrowseButton<T> myField;
    private final Project myProject;

    protected BrowseModuleValueActionListener(Project project2) {
        this.myProject = project2;
    }

    public void setField(ComponentWithBrowseButton<T> field) {
        this.myField = field;
        this.myField.addActionListener((ActionListener)this);
        this.myField.setButtonEnabled(!this.myProject.isDefault());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String text2 = this.showDialog();
        if (text2 != null) {
            ((TextAccessor)this.myField).setText(text2);
        }
    }

    public String getText() {
        return ((TextAccessor)this.myField).getText();
    }

    public JComponent getField() {
        return this.myField;
    }

    @Nullable
    protected abstract String showDialog();

    public Project getProject() {
        return this.myProject;
    }

    public void detach() {
        if (this.myField != null) {
            this.myField.removeActionListener((ActionListener)this);
            this.myField = null;
        }
    }
}

