/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleFoldingSettings;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AddEditDeleteListPanel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myMainComponent;
    private JCheckBox myCbUseSoftWrapsAtConsole;
    private JTextField myCommandsHistoryLimitField;
    private JCheckBox myCbOverrideConsoleCycleBufferSize;
    private JTextField myConsoleCycleBufferSizeField;
    private MyAddDeleteListPanel myPositivePanel;
    private MyAddDeleteListPanel myNegativePanel;
    private final ConsoleFoldingSettings mySettings = ConsoleFoldingSettings.getSettings();

    public JComponent createComponent() {
        if (this.myMainComponent == null) {
            this.myMainComponent = new JPanel(new BorderLayout());
            this.myCbUseSoftWrapsAtConsole = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.soft.wraps.at.console", (Object[])new Object[0]), false);
            this.myCommandsHistoryLimitField = new JTextField(3);
            this.myCbOverrideConsoleCycleBufferSize = new JCheckBox(ApplicationBundle.message((String)"checkbox.override.console.cycle.buffer.size", (Object[])new Object[]{String.valueOf(ConsoleBuffer.getLegacyCycleBufferSize() / 1024)}), false);
            this.myCbOverrideConsoleCycleBufferSize.addChangeListener(e -> this.myConsoleCycleBufferSizeField.setEnabled(this.myCbOverrideConsoleCycleBufferSize.isSelected()));
            this.myConsoleCycleBufferSizeField = new JTextField(3);
            JPanel northPanel = new JPanel(new GridBagLayout());
            GridBag gridBag = new GridBag();
            gridBag.anchor(17).setDefaultAnchor(17);
            northPanel.add((Component)this.myCbUseSoftWrapsAtConsole, gridBag.nextLine().next());
            northPanel.add(Box.createHorizontalGlue(), gridBag.next().coverLine());
            northPanel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.console.history.limit", (Object[])new Object[0])), gridBag.nextLine().next());
            northPanel.add((Component)this.myCommandsHistoryLimitField, gridBag.next());
            if (ConsoleBuffer.useCycleBuffer()) {
                northPanel.add((Component)this.myCbOverrideConsoleCycleBufferSize, gridBag.nextLine().next());
                northPanel.add((Component)this.myConsoleCycleBufferSizeField, gridBag.next());
                northPanel.add((Component)new JLabel(" KB"), gridBag.next());
            }
            if (!this.editFoldingsOnly()) {
                JPanel wrapper = new JPanel(new BorderLayout());
                wrapper.add((Component)northPanel, "West");
                this.myMainComponent.add((Component)wrapper, "North");
            }
            Splitter splitter = new Splitter(true);
            this.myMainComponent.add((Component)splitter, "Center");
            this.myPositivePanel = new MyAddDeleteListPanel("Fold console lines that contain", "Enter a substring of a console line you'd like to see folded:");
            this.myNegativePanel = new MyAddDeleteListPanel("Exceptions", "Enter a substring of a console line you don't want to fold:");
            splitter.setFirstComponent((JComponent)((Object)this.myPositivePanel));
            splitter.setSecondComponent((JComponent)((Object)this.myNegativePanel));
            this.myPositivePanel.getEmptyText().setText("Fold nothing");
            this.myNegativePanel.getEmptyText().setText("No exceptions");
        }
        return this.myMainComponent;
    }

    protected boolean editFoldingsOnly() {
        return false;
    }

    public void addRule(@NotNull String rule) {
        if (rule == null) {
            ConsoleConfigurable.$$$reportNull$$$0(0);
        }
        this.myPositivePanel.addRule(rule);
    }

    public boolean isModified() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        boolean isModified = !ContainerUtil.newHashSet((Object[])this.myNegativePanel.getListItems()).equals(ContainerUtil.newHashSet(this.mySettings.getNegativePatterns()));
        isModified |= !ContainerUtil.newHashSet((Object[])this.myPositivePanel.getListItems()).equals(ContainerUtil.newHashSet(this.mySettings.getPositivePatterns()));
        isModified |= this.isModified(this.myCbUseSoftWrapsAtConsole, editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE));
        UISettings uiSettings = UISettings.getInstance();
        isModified |= ConsoleConfigurable.isModified(this.myCommandsHistoryLimitField, uiSettings.getConsoleCommandHistoryLimit());
        if (ConsoleBuffer.useCycleBuffer()) {
            isModified |= this.isModified(this.myCbOverrideConsoleCycleBufferSize, uiSettings.getOverrideConsoleCycleBufferSize());
            isModified |= ConsoleConfigurable.isModified(this.myConsoleCycleBufferSizeField, uiSettings.getConsoleCycleBufferSizeKb());
        }
        return isModified;
    }

    private static boolean isModified(JTextField textField2, int value2) {
        try {
            int fieldValue = Integer.parseInt(textField2.getText().trim());
            return fieldValue != value2;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        editorSettings.setUseSoftWraps(this.myCbUseSoftWrapsAtConsole.isSelected(), SoftWrapAppliancePlaces.CONSOLE);
        boolean uiSettingsChanged = false;
        if (ConsoleConfigurable.isModified(this.myCommandsHistoryLimitField, uiSettings.getConsoleCommandHistoryLimit())) {
            uiSettings.setConsoleCommandHistoryLimit(Math.max(0, Math.min(1000, Integer.parseInt(this.myCommandsHistoryLimitField.getText().trim()))));
            uiSettingsChanged = true;
        }
        if (ConsoleBuffer.useCycleBuffer()) {
            if (this.isModified(this.myCbOverrideConsoleCycleBufferSize, uiSettings.getOverrideConsoleCycleBufferSize())) {
                uiSettings.setOverrideConsoleCycleBufferSize(this.myCbOverrideConsoleCycleBufferSize.isSelected());
                uiSettingsChanged = true;
            }
            if (ConsoleConfigurable.isModified(this.myConsoleCycleBufferSizeField, uiSettings.getConsoleCycleBufferSizeKb())) {
                uiSettings.setConsoleCycleBufferSizeKb(Math.max(0, Math.min(102400, Integer.parseInt(this.myConsoleCycleBufferSizeField.getText().trim()))));
                uiSettingsChanged = true;
            }
        }
        if (uiSettingsChanged) {
            uiSettings.fireUISettingsChanged();
        }
        this.myNegativePanel.applyTo(this.mySettings.getNegativePatterns());
        this.myPositivePanel.applyTo(this.mySettings.getPositivePatterns());
    }

    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        this.myCbUseSoftWrapsAtConsole.setSelected(editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE));
        this.myCommandsHistoryLimitField.setText(Integer.toString(uiSettings.getConsoleCommandHistoryLimit()));
        this.myCbOverrideConsoleCycleBufferSize.setEnabled(ConsoleBuffer.useCycleBuffer());
        this.myCbOverrideConsoleCycleBufferSize.setSelected(uiSettings.getOverrideConsoleCycleBufferSize());
        this.myConsoleCycleBufferSizeField.setEnabled(ConsoleBuffer.useCycleBuffer() && uiSettings.getOverrideConsoleCycleBufferSize());
        this.myConsoleCycleBufferSizeField.setText(Integer.toString(uiSettings.getConsoleCycleBufferSizeKb()));
        this.myNegativePanel.resetFrom(this.mySettings.getNegativePatterns());
        this.myPositivePanel.resetFrom(this.mySettings.getPositivePatterns());
    }

    public void disposeUIResources() {
        this.myMainComponent = null;
        this.myNegativePanel = null;
        this.myPositivePanel = null;
    }

    @NotNull
    public String getId() {
        String string = this.getDisplayName();
        if (string == null) {
            ConsoleConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return "Console";
    }

    public String getHelpTopic() {
        return "reference.idesettings.console.folding";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/ConsoleConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/ConsoleConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAddDeleteListPanel
    extends AddEditDeleteListPanel<String> {
        private final String myQuery;

        MyAddDeleteListPanel(String title, String query) {
            super(title, new ArrayList());
            this.myQuery = query;
            new ListSpeedSearch(this.myList);
        }

        @Nullable
        protected String findItemToAdd() {
            return this.showEditDialog("");
        }

        @Nullable
        private String showEditDialog(String initialValue) {
            return Messages.showInputDialog((Component)((Object)this), (String)this.myQuery, (String)"Folding Pattern", (Icon)Messages.getQuestionIcon(), (String)initialValue, (InputValidator)new InputValidatorEx(){

                public boolean checkInput(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                public boolean canClose(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }

                @Nullable
                public String getErrorText(String inputString) {
                    if (!this.checkInput(inputString)) {
                        return "Console folding rule string cannot be empty";
                    }
                    return null;
                }
            });
        }

        void resetFrom(List<String> patterns) {
            this.myListModel.clear();
            patterns.stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(this.myListModel::addElement);
        }

        void applyTo(List<String> patterns) {
            patterns.clear();
            for (Object o : this.getListItems()) {
                patterns.add((String)o);
            }
        }

        public void addRule(String rule) {
            this.addElement(rule);
        }

        protected String editSelectedItem(String item) {
            return this.showEditDialog(item);
        }
    }
}

