/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;

public class JreVersionDetector {
    private String myLastAlternativeJrePath;
    private boolean myLastIsJre50;

    public boolean isModuleJre50Configured(ModuleBasedConfiguration configuration) {
        Module module2 = configuration.getConfigurationModule().getModule();
        if (module2 != null && !module2.isDisposed()) {
            return JreVersionDetector.isJre50(ModuleRootManager.getInstance((Module)module2).getSdk());
        }
        return JreVersionDetector.isJre50(ProjectRootManager.getInstance((Project)configuration.getProject()).getProjectSdk());
    }

    public boolean isJre50Configured(CommonJavaRunConfigurationParameters configuration) {
        String alternativeJrePath;
        if (configuration.isAlternativeJrePathEnabled() && !StringUtil.isEmptyOrSpaces((String)(alternativeJrePath = configuration.getAlternativeJrePath()))) {
            if (Comparing.equal((String)alternativeJrePath, (String)this.myLastAlternativeJrePath)) {
                return this.myLastIsJre50;
            }
            this.myLastAlternativeJrePath = alternativeJrePath;
            String versionString = SdkVersionUtil.detectJdkVersion((String)this.myLastAlternativeJrePath);
            this.myLastIsJre50 = versionString != null && JreVersionDetector.isJre50(versionString);
            return this.myLastIsJre50;
        }
        return false;
    }

    private static boolean isJre50(Sdk jdk) {
        return JavaSdkUtil.isJdkAtLeast(jdk, JavaSdkVersion.JDK_1_5);
    }

    private static boolean isJre50(String versionString) {
        if (versionString == null) {
            return false;
        }
        JavaSdkVersion version = JavaSdkVersion.fromVersionString((String)versionString);
        return version != null && version.isAtLeast(JavaSdkVersion.JDK_1_5);
    }
}

