/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.util.Ref;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FrameworkLibraryValidatorImpl
extends FrameworkLibraryValidator {
    private CustomLibraryDescription myLibraryDescription;
    private final LibrariesValidatorContext myContext;
    private final FacetValidatorsManager myValidatorsManager;
    private final String myLibraryCategoryName;

    public FrameworkLibraryValidatorImpl(CustomLibraryDescription libraryDescription, LibrariesValidatorContext context, FacetValidatorsManager validatorsManager, String libraryCategoryName) {
        this.myLibraryDescription = libraryDescription;
        this.myContext = context;
        this.myValidatorsManager = validatorsManager;
        this.myLibraryCategoryName = libraryCategoryName;
    }

    @NotNull
    public ValidationResult check() {
        Set<? extends LibraryKind> libraryKinds = this.myLibraryDescription.getSuitableLibraryKinds();
        Ref found = Ref.create((Object)false);
        this.myContext.getRootModel().orderEntries().using((RootModelProvider)this.myContext.getModulesProvider()).recursively().librariesOnly().forEachLibrary(library -> {
            if (LibraryPresentationManager.getInstance().isLibraryOfKind((Library)library, this.myContext.getLibrariesContainer(), libraryKinds)) {
                found.set((Object)true);
                return false;
            }
            return true;
        });
        if (((Boolean)found.get()).booleanValue()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                FrameworkLibraryValidatorImpl.$$$reportNull$$$0(0);
            }
            return validationResult;
        }
        ValidationResult validationResult = new ValidationResult(IdeBundle.message((String)"label.missed.libraries.text", (Object[])new Object[]{this.myLibraryCategoryName}), (FacetConfigurationQuickFix)new LibrariesQuickFix(this.myLibraryDescription));
        if (validationResult == null) {
            FrameworkLibraryValidatorImpl.$$$reportNull$$$0(1);
        }
        return validationResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/libraries/FrameworkLibraryValidatorImpl", "check"));
    }

    private class LibrariesQuickFix
    extends FacetConfigurationQuickFix {
        private CustomLibraryDescription myDescription;

        public LibrariesQuickFix(CustomLibraryDescription description) {
            super(IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
            this.myDescription = description;
        }

        public void run(JComponent place) {
            AddCustomLibraryDialog dialog2 = AddCustomLibraryDialog.createDialog(this.myDescription, FrameworkLibraryValidatorImpl.this.myContext.getLibrariesContainer(), FrameworkLibraryValidatorImpl.this.myContext.getModule(), FrameworkLibraryValidatorImpl.this.myContext.getModifiableRootModel(), null);
            dialog2.show();
            FrameworkLibraryValidatorImpl.this.myValidatorsManager.validate();
        }
    }
}

