/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.replaceInProject;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindInPathAction;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class ReplaceInProjectManager {
    static final NotificationGroup NOTIFICATION_GROUP = FindInPathAction.NOTIFICATION_GROUP;
    private final Project myProject;
    private boolean myIsFindInProgress = false;

    public static ReplaceInProjectManager getInstance(Project project2) {
        return (ReplaceInProjectManager)ServiceManager.getService((Project)project2, ReplaceInProjectManager.class);
    }

    public ReplaceInProjectManager(Project project2) {
        this.myProject = project2;
    }

    public static boolean hasReadOnlyUsages(Collection<Usage> usages) {
        for (Usage usage : usages) {
            if (!usage.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public void replaceInProject(@NotNull DataContext dataContext) {
        boolean isOpenInNewTabEnabled;
        boolean toOpenInNewTab;
        Content selectedContent;
        if (dataContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(0);
        }
        if ((selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true)) != null && selectedContent.isPinned()) {
            toOpenInNewTab = true;
            isOpenInNewTabEnabled = false;
        } else {
            toOpenInNewTab = FindSettings.getInstance().isShowResultsInSeparateView();
            isOpenInNewTabEnabled = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        FindModel findModel = findManager.getFindInProjectModel().clone();
        findModel.setReplaceState(true);
        findModel.setOpenInNewTabVisible(true);
        findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
        findModel.setOpenInNewTab(toOpenInNewTab);
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        FindInProjectUtil.initStringToFindFromDataContext(findModel, dataContext);
        findManager.showFindDialog(findModel, () -> {
            if (!findModel.isProjectScope() && FindInProjectUtil.getDirectory(findModel) == null && findModel.getModuleName() == null && findModel.getCustomScope() == null) {
                return;
            }
            UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
            if (manager == null) {
                return;
            }
            findManager.getFindInProjectModel().copyFrom(findModel);
            FindModel findModelCopy = findModel.clone();
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(findModel.isOpenInNewTab(), findModelCopy);
            FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, true, presentation);
            processPresentation.setShowFindOptionsPrompt(findModel.isPromptOnReplace());
            UsageSearcherFactory factory = new UsageSearcherFactory(findModelCopy, processPresentation);
            this.searchAndShowUsages(manager, factory, findModelCopy, presentation, processPresentation, findManager);
        });
    }

    public void searchAndShowUsages(@NotNull UsageViewManager manager, @NotNull Factory<UsageSearcher> usageSearcherFactory, @NotNull FindModel findModelCopy, @NotNull FindManager findManager) {
        if (manager == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(1);
        }
        if (usageSearcherFactory == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(2);
        }
        if (findModelCopy == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(3);
        }
        if (findManager == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(4);
        }
        UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(true, findModelCopy);
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, true, presentation);
        this.searchAndShowUsages(manager, usageSearcherFactory, findModelCopy, presentation, processPresentation, findManager);
    }

    public void searchAndShowUsages(@NotNull UsageViewManager manager, @NotNull Factory<UsageSearcher> usageSearcherFactory, final @NotNull FindModel findModelCopy, @NotNull UsageViewPresentation presentation, final @NotNull FindUsagesProcessPresentation processPresentation, FindManager findManager) {
        if (manager == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(5);
        }
        if (usageSearcherFactory == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(6);
        }
        if (findModelCopy == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(7);
        }
        if (presentation == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(8);
        }
        if (processPresentation == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(9);
        }
        presentation.setMergeDupLinesAvailable(false);
        final ReplaceContext[] context = new ReplaceContext[1];
        ReplaceInProjectTarget target2 = new ReplaceInProjectTarget(this.myProject, findModelCopy);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(target2);
        manager.searchAndShowUsages(new UsageTarget[]{target2}, usageSearcherFactory, processPresentation, presentation, new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    1.$$$reportNull$$$0(0);
                }
                context[0] = new ReplaceContext(usageView, findModelCopy);
                ReplaceInProjectManager.this.addReplaceActions(context[0]);
            }

            public void findingUsagesFinished(UsageView usageView) {
                if (context[0] != null && !processPresentation.isShowFindOptionsPrompt()) {
                    TransactionGuard.submitTransaction((Disposable)ReplaceInProjectManager.this.myProject, () -> {
                        ReplaceInProjectManager.this.replaceUsagesUnderCommand(context[0], usageView.getUsages());
                        context[0].invalidateExcludedSetCache();
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/replaceInProject/ReplaceInProjectManager$1", "usageViewCreated"));
            }
        });
    }

    private void replaceWithPrompt(ReplaceContext replaceContext) {
        List _usages = replaceContext.getUsageView().getSortedUsages();
        if (ReplaceInProjectManager.hasReadOnlyUsages(_usages)) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(FindBundle.message("find.replace.occurrences.found.in.read.only.files.status", new Object[0]));
            return;
        }
        Usage[] usages = _usages.toArray(new Usage[_usages.size()]);
        for (int i = 0; i < usages.length; ++i) {
            Runnable runnable2;
            int result2;
            PsiFile psiFile;
            Usage usage = usages[i];
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            PsiElement elt = usageInfo.getElement();
            if (elt == null || !(psiFile = elt.getContainingFile()).isWritable()) continue;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            Runnable selectOnEditorRunnable = () -> {
                if (virtualFile != null && ((Boolean)ReadAction.compute(() -> virtualFile.isValid())).booleanValue() && usage.isValid()) {
                    usage.highlightInEditor();
                    replaceContext.getUsageView().selectUsages(new Usage[]{usage});
                }
            };
            String path = (String)ReadAction.compute(() -> virtualFile != null ? virtualFile.getPath() : null);
            CommandProcessor.getInstance().executeCommand(this.myProject, selectOnEditorRunnable, FindBundle.message("find.replace.select.on.editor.command", new Object[0]), null);
            String title = FindBundle.message("find.replace.found.usage.title", i + 1, usages.length, path);
            try {
                this.replaceUsage(usage, replaceContext.getFindModel(), replaceContext.getExcludedSetCached(), true);
                result2 = FindManager.getInstance((Project)this.myProject).showPromptDialog(replaceContext.getFindModel(), title);
            }
            catch (FindManager.MalformedReplacementStringException e) {
                ReplaceInProjectManager.markAsMalformedReplacement(replaceContext, usage);
                result2 = FindManager.getInstance((Project)this.myProject).showMalformedReplacementPrompt(replaceContext.getFindModel(), title, e);
            }
            if (result2 == 1) {
                return;
            }
            if (result2 == 2) continue;
            int currentNumber = i;
            if (result2 == 0) {
                Ref success = Ref.create();
                runnable2 = () -> success.set((Object)this.replaceUsageAndRemoveFromView(usage, replaceContext));
                CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, FindBundle.message("find.replace.command", new Object[0]), null);
                if (this.closeUsageViewIfEmpty(replaceContext.getUsageView(), (Boolean)success.get())) {
                    return;
                }
            }
            if (result2 == 6) {
                PsiElement nextElt;
                int j;
                for (j = i + 1; j < usages.length && ((nextElt = ((UsageInfo2UsageAdapter)usages[j]).getUsageInfo().getElement()) == null || nextElt.getContainingFile() == psiFile); ++j) {
                }
                i = j - 1;
            }
            if (result2 == 4) {
                int[] nextNumber = new int[1];
                runnable2 = () -> {
                    int j;
                    boolean success = true;
                    for (j = currentNumber; j < usages.length; ++j) {
                        Usage usage1 = usages[j];
                        UsageInfo usageInfo1 = ((UsageInfo2UsageAdapter)usage1).getUsageInfo();
                        PsiElement elt1 = usageInfo1.getElement();
                        if (elt1 == null) continue;
                        PsiFile otherPsiFile = elt1.getContainingFile();
                        if (!otherPsiFile.equals(psiFile)) break;
                        if (this.replaceUsageAndRemoveFromView(usage1, replaceContext)) continue;
                        success = false;
                    }
                    this.closeUsageViewIfEmpty(replaceContext.getUsageView(), success);
                    nextNumber[0] = j;
                };
                CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, FindBundle.message("find.replace.command", new Object[0]), null);
                i = nextNumber[0] - 1;
            }
            if (result2 != 5) continue;
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                boolean success = this.replaceUsages(replaceContext, _usages);
                this.closeUsageViewIfEmpty(replaceContext.getUsageView(), success);
            }, FindBundle.message("find.replace.command", new Object[0]), null);
            break;
        }
    }

    private boolean replaceUsageAndRemoveFromView(Usage usage, ReplaceContext replaceContext) {
        try {
            if (this.replaceUsage(usage, replaceContext.getFindModel(), replaceContext.getExcludedSetCached(), false)) {
                replaceContext.getUsageView().removeUsage(usage);
            }
        }
        catch (FindManager.MalformedReplacementStringException e) {
            ReplaceInProjectManager.markAsMalformedReplacement(replaceContext, usage);
            return false;
        }
        return true;
    }

    private void addReplaceActions(ReplaceContext replaceContext) {
        Runnable replaceRunnable = () -> {
            Set usages = replaceContext.getUsageView().getUsages();
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            if (usages.isEmpty()) {
                return;
            }
            for (Usage usage : usages) {
                if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
                files.add(((UsageInfo2UsageAdapter)usage).getFile());
            }
            if (files.size() < 2 || 0 == JOptionPane.showConfirmDialog(replaceContext.getUsageView().getComponent(), FindBundle.message("find.replace.all.confirmation", usages.size(), replaceContext.getFindModel().getStringToFind(), files.size(), replaceContext.getFindModel().getStringToReplace()), FindBundle.message("find.replace.all.confirmation.title", new Object[0]), 2)) {
                this.replaceUsagesUnderCommand(replaceContext, usages);
            }
        };
        replaceContext.getUsageView().addButtonToLowerPane(replaceRunnable, FindBundle.message("find.replace.all.action", new Object[0]));
        Runnable replaceSelectedRunnable = () -> this.replaceUsagesUnderCommand(replaceContext, replaceContext.getUsageView().getSelectedUsages());
        replaceContext.getUsageView().addButtonToLowerPane(replaceSelectedRunnable, FindBundle.message("find.replace.selected.action", new Object[0]));
    }

    private boolean replaceUsages(@NotNull ReplaceContext replaceContext, @NotNull Collection<Usage> usages) {
        if (replaceContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(10);
        }
        if (usages == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(11);
        }
        if (!this.ensureUsagesWritable(replaceContext, usages)) {
            return true;
        }
        int[] replacedCount = new int[]{0};
        boolean[] success = new boolean[]{true};
        success[0] = success[0] & ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithProgressInDispatchThread(FindBundle.message("find.replace.all.action", new Object[0]), this.myProject, null, "Stop", (Consumer<ProgressIndicator>)((Consumer)indicator -> {
            if (usages == null) {
                ReplaceInProjectManager.$$$reportNull$$$0(22);
            }
            if (replaceContext == null) {
                ReplaceInProjectManager.$$$reportNull$$$0(23);
            }
            int processed2 = 0;
            VirtualFile lastFile = null;
            for (Usage usage : usages) {
                VirtualFile virtualFile;
                indicator.checkCanceled();
                indicator.setFraction((double)((float)(++processed2) / (float)usages.size()));
                if (usage instanceof UsageInFile && (virtualFile = ((UsageInFile)usage).getFile()) != null && !virtualFile.equals(lastFile)) {
                    indicator.setText2(virtualFile.getPresentableUrl());
                    lastFile = virtualFile;
                }
                ProgressManager.getInstance().executeNonCancelableSection(() -> {
                    if (replaceContext == null) {
                        ReplaceInProjectManager.$$$reportNull$$$0(24);
                    }
                    try {
                        if (this.replaceUsage(usage, replaceContext.getFindModel(), replaceContext.getExcludedSetCached(), false)) {
                            replacedCount[0] = replacedCount[0] + 1;
                        }
                    }
                    catch (FindManager.MalformedReplacementStringException ex) {
                        ReplaceInProjectManager.markAsMalformedReplacement(replaceContext, usage);
                        success[0] = false;
                    }
                });
            }
        }));
        replaceContext.getUsageView().removeUsagesBulk(usages);
        ReplaceInProjectManager.reportNumberReplacedOccurrences(this.myProject, replacedCount[0]);
        return success[0];
    }

    private static void markAsMalformedReplacement(ReplaceContext replaceContext, Usage usage) {
        replaceContext.getUsageView().excludeUsages(new Usage[]{usage});
    }

    public static void reportNumberReplacedOccurrences(Project project2, int occurrences) {
        StatusBar statusBar;
        if (occurrences != 0 && (statusBar = WindowManager.getInstance().getStatusBar(project2)) != null) {
            statusBar.setInfo(FindBundle.message("0.occurrences.replaced", occurrences));
        }
    }

    public boolean replaceUsage(@NotNull Usage usage, @NotNull FindModel findModel, @NotNull Set<Usage> excludedSet, boolean justCheck) throws FindManager.MalformedReplacementStringException {
        if (usage == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(12);
        }
        if (findModel == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(13);
        }
        if (excludedSet == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(14);
        }
        Ref exceptionResult = Ref.create();
        boolean result2 = (Boolean)WriteAction.compute(() -> {
            if (excludedSet == null) {
                ReplaceInProjectManager.$$$reportNull$$$0(18);
            }
            if (usage == null) {
                ReplaceInProjectManager.$$$reportNull$$$0(19);
            }
            if (findModel == null) {
                ReplaceInProjectManager.$$$reportNull$$$0(20);
            }
            if (excludedSet.contains(usage)) {
                return false;
            }
            Document document = ((UsageInfo2UsageAdapter)usage).getDocument();
            if (!document.isWritable()) {
                return false;
            }
            boolean result1 = ((UsageInfo2UsageAdapter)usage).processRangeMarkers(segment -> {
                if (findModel == null) {
                    ReplaceInProjectManager.$$$reportNull$$$0(21);
                }
                int textOffset = segment.getStartOffset();
                int textEndOffset = segment.getEndOffset();
                Ref stringToReplace = Ref.create();
                try {
                    if (!this.getStringToReplace(textOffset, textEndOffset, document, findModel, (Ref<String>)stringToReplace)) {
                        return true;
                    }
                    if (!stringToReplace.isNull() && !justCheck) {
                        document.replaceString(textOffset, textEndOffset, (CharSequence)stringToReplace.get());
                    }
                }
                catch (FindManager.MalformedReplacementStringException e) {
                    exceptionResult.set((Object)e);
                    return false;
                }
                return true;
            });
            return result1;
        });
        if (!exceptionResult.isNull()) {
            throw (FindManager.MalformedReplacementStringException)((Object)exceptionResult.get());
        }
        return result2;
    }

    private boolean getStringToReplace(int textOffset, int textEndOffset, Document document, FindModel findModel, Ref<String> stringToReplace) throws FindManager.MalformedReplacementStringException {
        if (textOffset < 0 || textOffset >= document.getTextLength()) {
            return false;
        }
        if (textEndOffset < 0 || textOffset > document.getTextLength()) {
            return false;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        CharSequence foundString = document.getCharsSequence().subSequence(textOffset, textEndOffset);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        FindResult findResult = findManager.findString(document.getCharsSequence(), textOffset, findModel, file2 != null ? file2.getVirtualFile() : null);
        if (!findResult.isStringFound() || findResult.getStartOffset() < textOffset || findResult.getEndOffset() > textEndOffset) {
            return false;
        }
        stringToReplace.set((Object)FindManager.getInstance((Project)this.myProject).getStringToReplace(foundString.toString(), findModel, textOffset, (CharSequence)document.getText()));
        return true;
    }

    private void replaceUsagesUnderCommand(@NotNull ReplaceContext replaceContext, @NotNull Set<Usage> usagesSet) {
        if (replaceContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(15);
        }
        if (usagesSet == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(16);
        }
        if (usagesSet.isEmpty()) {
            return;
        }
        ArrayList<Usage> usages = new ArrayList<Usage>(usagesSet);
        Collections.sort(usages, UsageViewImpl.USAGE_COMPARATOR);
        if (!this.ensureUsagesWritable(replaceContext, usages)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (replaceContext == null) {
                ReplaceInProjectManager.$$$reportNull$$$0(17);
            }
            boolean success = this.replaceUsages(replaceContext, usages);
            UsageView usageView = replaceContext.getUsageView();
            if (this.closeUsageViewIfEmpty(usageView, success)) {
                return;
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)usageView.getComponent(), true));
        }, FindBundle.message("find.replace.command", new Object[0]), null);
        replaceContext.invalidateExcludedSetCache();
    }

    private boolean ensureUsagesWritable(ReplaceContext replaceContext, Collection<Usage> selectedUsages) {
        int result2;
        HashSet<VirtualFile> readOnlyFiles = null;
        for (Usage usage : selectedUsages) {
            VirtualFile file2 = ((UsageInFile)usage).getFile();
            if (file2 == null || file2.isWritable()) continue;
            if (readOnlyFiles == null) {
                readOnlyFiles = new HashSet<VirtualFile>();
            }
            readOnlyFiles.add(file2);
        }
        if (readOnlyFiles != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
        }
        return !ReplaceInProjectManager.hasReadOnlyUsages(selectedUsages) || (result2 = Messages.showOkCancelDialog((Component)replaceContext.getUsageView().getComponent(), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.prompt", new Object[0]), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.title", new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }

    private boolean closeUsageViewIfEmpty(UsageView usageView, boolean success) {
        if (usageView.getUsages().isEmpty()) {
            usageView.close();
            return true;
        }
        if (!success) {
            NOTIFICATION_GROUP.createNotification("One or more malformed replacement strings", MessageType.ERROR).notify(this.myProject);
        }
        return false;
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !FindInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageSearcherFactory";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModelCopy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceContext";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 13: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedSet";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesSet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceInProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "searchAndShowUsages";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceUsages";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceUsage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceUsagesUnderCommand";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$replaceUsagesUnderCommand$14";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$replaceUsage$12";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$11";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$replaceUsages$10";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$9";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class UsageSearcherFactory
    implements Factory<UsageSearcher> {
        private final FindModel myFindModelCopy;
        private final FindUsagesProcessPresentation myProcessPresentation;

        private UsageSearcherFactory(@NotNull FindModel findModelCopy, FindUsagesProcessPresentation processPresentation) {
            if (findModelCopy == null) {
                UsageSearcherFactory.$$$reportNull$$$0(0);
            }
            if (processPresentation == null) {
                UsageSearcherFactory.$$$reportNull$$$0(1);
            }
            this.myFindModelCopy = findModelCopy;
            this.myProcessPresentation = processPresentation;
        }

        public UsageSearcher create() {
            return new UsageSearcher(){

                public void generate(@NotNull Processor<Usage> processor2) {
                    if (processor2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        ReplaceInProjectManager.this.myIsFindInProgress = true;
                        FindInProjectUtil.findUsages(UsageSearcherFactory.this.myFindModelCopy, ReplaceInProjectManager.this.myProject, (Processor<UsageInfo>)new AdapterProcessor(processor2, (Function)UsageInfo2UsageAdapter.CONVERTER), UsageSearcherFactory.this.myProcessPresentation);
                    }
                    finally {
                        ReplaceInProjectManager.this.myIsFindInProgress = false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/replaceInProject/ReplaceInProjectManager$UsageSearcherFactory$1", "generate"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "findModelCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processPresentation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$UsageSearcherFactory";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceInProjectTarget
    extends FindInProjectUtil.StringUsageTarget {
        public ReplaceInProjectTarget(@NotNull Project project2, @NotNull FindModel findModel) {
            if (project2 == null) {
                ReplaceInProjectTarget.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                ReplaceInProjectTarget.$$$reportNull$$$0(1);
            }
            super(project2, findModel);
        }

        @Override
        @NotNull
        public String getLongDescriptiveName() {
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(false, this.myFindModel);
            String string = "Replace " + StringUtil.decapitalize((String)presentation.getToolwindowTitle()) + " with '" + this.myFindModel.getStringToReplace() + "'";
            if (string == null) {
                ReplaceInProjectTarget.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("ReplaceInPath");
        }

        @Override
        public void showSettings() {
            Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
            JComponent component = selectedContent == null ? null : selectedContent.getComponent();
            ReplaceInProjectManager findInProjectManager = ReplaceInProjectManager.getInstance(this.myProject);
            findInProjectManager.replaceInProject(DataManager.getInstance().getDataContext((Component)component));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceInProjectTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceInProjectTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLongDescriptiveName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ReplaceContext {
        private final UsageView usageView;
        private final FindModel findModel;
        private Set<Usage> excludedSet;

        ReplaceContext(@NotNull UsageView usageView, @NotNull FindModel findModel) {
            if (usageView == null) {
                ReplaceContext.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                ReplaceContext.$$$reportNull$$$0(1);
            }
            this.usageView = usageView;
            this.findModel = findModel;
        }

        @NotNull
        public FindModel getFindModel() {
            FindModel findModel = this.findModel;
            if (findModel == null) {
                ReplaceContext.$$$reportNull$$$0(2);
            }
            return findModel;
        }

        @NotNull
        public UsageView getUsageView() {
            UsageView usageView = this.usageView;
            if (usageView == null) {
                ReplaceContext.$$$reportNull$$$0(3);
            }
            return usageView;
        }

        @NotNull
        public Set<Usage> getExcludedSetCached() {
            if (this.excludedSet == null) {
                this.excludedSet = this.usageView.getExcludedUsages();
            }
            Set<Usage> set2 = this.excludedSet;
            if (set2 == null) {
                ReplaceContext.$$$reportNull$$$0(4);
            }
            return set2;
        }

        public void invalidateExcludedSetCache() {
            this.excludedSet = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFindModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsageView";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExcludedSetCached";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

