/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.ByteContent;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryException;
import com.intellij.history.core.ByteContentRetriever;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeListStorageImpl;
import com.intellij.history.core.InMemoryChangeListStorage;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryActionImpl;
import com.intellij.history.integration.LocalHistoryEventDispatcher;
import com.intellij.history.integration.LocalHistoryUtil;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.models.EntireFileHistoryDialogModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryImpl
extends LocalHistory
implements ApplicationComponent,
Disposable {
    private final MessageBus myBus;
    private MessageBusConnection myConnection;
    private ChangeList myChangeList;
    private LocalHistoryFacade myVcs;
    private IdeaGateway myGateway;
    private LocalHistoryEventDispatcher myEventDispatcher;
    private final AtomicBoolean isInitialized;
    private Runnable myShutdownTask;

    public static LocalHistoryImpl getInstanceImpl() {
        return (LocalHistoryImpl)LocalHistoryImpl.getInstance();
    }

    public LocalHistoryImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            LocalHistoryImpl.$$$reportNull$$$0(0);
        }
        this.isInitialized = new AtomicBoolean();
        this.myBus = bus;
    }

    public void initComponent() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myShutdownTask = () -> this.doDispose();
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutdownTask);
        this.initHistory();
        this.isInitialized.set(true);
    }

    protected void initHistory() {
        ChangeListStorage storage2;
        try {
            storage2 = new ChangeListStorageImpl(this.getStorageDir());
        }
        catch (Throwable e) {
            LocalHistoryLog.LOG.warn("cannot create storage, in-memory  implementation will be used", e);
            storage2 = new InMemoryChangeListStorage();
        }
        this.myChangeList = new ChangeList(storage2);
        this.myVcs = new LocalHistoryFacade(this.myChangeList);
        this.myGateway = new IdeaGateway();
        this.myEventDispatcher = new LocalHistoryEventDispatcher(this.myVcs, this.myGateway);
        CommandProcessor.getInstance().addCommandListener((CommandListener)this.myEventDispatcher, (Disposable)this);
        this.myConnection = this.myBus.connect();
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myEventDispatcher);
        VirtualFileManager fm = VirtualFileManager.getInstance();
        fm.addVirtualFileManagerListener((VirtualFileManagerListener)this.myEventDispatcher, (Disposable)this);
    }

    public File getStorageDir() {
        return new File(this.getSystemPath(), "LocalHistory");
    }

    protected String getSystemPath() {
        return PathManager.getSystemPath();
    }

    public void dispose() {
        this.doDispose();
    }

    private void doDispose() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        long period = (long)Registry.intValue((String)"localHistory.daysToKeep") * 1000L * 60L * 60L * 24L;
        this.myConnection.disconnect();
        this.myConnection = null;
        LocalHistoryLog.LOG.debug("Purging local history...");
        this.myChangeList.purgeObsolete(period);
        this.myChangeList.close();
        LocalHistoryLog.LOG.debug("Local history storage successfully closed.");
        ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutdownTask);
    }

    public void cleanupForNextTest() {
        this.doDispose();
        FileUtil.delete((File)this.getStorageDir());
        this.initComponent();
    }

    public LocalHistoryAction startAction(String name2) {
        if (!this.isInitialized()) {
            return LocalHistoryAction.NULL;
        }
        LocalHistoryActionImpl a = new LocalHistoryActionImpl(this.myEventDispatcher, name2);
        a.start();
        return a;
    }

    public Label putUserLabel(Project p, @NotNull String name2) {
        if (name2 == null) {
            LocalHistoryImpl.$$$reportNull$$$0(1);
        }
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putUserLabel(name2, LocalHistoryImpl.getProjectId(p)));
    }

    private static String getProjectId(Project p) {
        return p.getLocationHash();
    }

    public Label putSystemLabel(Project p, @NotNull String name2, int color) {
        if (name2 == null) {
            LocalHistoryImpl.$$$reportNull$$$0(2);
        }
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putSystemLabel(name2, LocalHistoryImpl.getProjectId(p), color));
    }

    public void addVFSListenerAfterLocalHistoryOne(VirtualFileListener virtualFileListener, Disposable disposable) {
        this.myEventDispatcher.addVirtualFileListener(virtualFileListener, disposable);
    }

    private Label label(final LabelImpl impl) {
        return new Label(){

            public void revert(@NotNull Project project2, @NotNull VirtualFile file2) throws LocalHistoryException {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalHistoryImpl.this.revertToLabel(project2, file2, impl);
            }

            public ByteContent getByteContent(String path) {
                return (ByteContent)ReadAction.compute(() -> impl.getByteContent(LocalHistoryImpl.this.myGateway.createTransientRootEntryForPathOnly(path), path));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/history/integration/LocalHistoryImpl$1";
                objectArray[2] = "revert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public byte[] getByteContent(VirtualFile f, FileRevisionTimestampComparator c) {
        if (!this.isInitialized()) {
            return null;
        }
        if (!this.myGateway.areContentChangesVersioned(f)) {
            return null;
        }
        return (byte[])ReadAction.compute(() -> new ByteContentRetriever(this.myGateway, this.myVcs, f, c).getResult());
    }

    public boolean isUnderControl(VirtualFile f) {
        return this.isInitialized() && this.myGateway.isVersioned(f);
    }

    private boolean isInitialized() {
        return this.isInitialized.get();
    }

    @Nullable
    public LocalHistoryFacade getFacade() {
        return this.myVcs;
    }

    @Nullable
    public IdeaGateway getGateway() {
        return this.myGateway;
    }

    private void revertToLabel(@NotNull Project project2, @NotNull VirtualFile f, @NotNull LabelImpl impl) throws LocalHistoryException {
        HistoryDialogModel dirHistoryModel;
        int leftRev;
        if (project2 == null) {
            LocalHistoryImpl.$$$reportNull$$$0(3);
        }
        if (f == null) {
            LocalHistoryImpl.$$$reportNull$$$0(4);
        }
        if (impl == null) {
            LocalHistoryImpl.$$$reportNull$$$0(5);
        }
        if ((leftRev = LocalHistoryUtil.findRevisionIndexToRevert(dirHistoryModel = f.isDirectory() ? new DirectoryHistoryDialogModel(project2, this.myGateway, this.myVcs, f) : new EntireFileHistoryDialogModel(project2, this.myGateway, this.myVcs, f), impl)) < 0) {
            throw new LocalHistoryException("Couldn't find label revision");
        }
        if (leftRev == 0) {
            return;
        }
        try {
            dirHistoryModel.selectRevisions(-1, leftRev - 1);
            dirHistoryModel.createReverter().revert();
        }
        catch (IOException e) {
            throw new LocalHistoryException(String.format("Couldn't revert %s to local history label.", f.getName()), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/integration/LocalHistoryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "putSystemLabel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "revertToLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

