/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileIconPatcher;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntheticElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JavaFileIconPatcher
implements FileIconPatcher {
    public Icon patchIcon(Icon baseIcon, VirtualFile file2, int flags, Project project2) {
        if (project2 == null) {
            return baseIcon;
        }
        Icon icon = JavaFileIconPatcher.replaceIcon(file2, flags, project2, baseIcon);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        if (fileIndex.isInSource(file2) && CompilerManager.getInstance((Project)project2).isExcludedFromCompilation(file2)) {
            return new LayeredIcon(new Icon[]{icon, PlatformIcons.EXCLUDED_FROM_COMPILE_ICON});
        }
        return icon;
    }

    private static Icon replaceIcon(VirtualFile file2, @Iconable.IconFlags int flags, Project project2, Icon baseIcon) {
        PsiClass[] classes2;
        FileType fileType = file2.getFileType();
        if (fileType == StdFileTypes.JAVA && !FileIndexUtil.isJavaSourceFile((Project)project2, (VirtualFile)file2)) {
            return PlatformIcons.JAVA_OUTSIDE_SOURCE_ICON;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
        if (psiFile instanceof PsiClassOwner && psiFile.getViewProvider().getBaseLanguage() == JavaLanguage.INSTANCE && (classes2 = ((PsiClassOwner)psiFile).getClasses()).length > 0) {
            String fileName = file2.getNameWithoutExtension();
            for (PsiClass aClass : classes2) {
                if (aClass instanceof SyntheticElement) {
                    return baseIcon;
                }
                if (!Comparing.strEqual((String)aClass.getName(), (String)fileName)) continue;
                return aClass.getIcon(flags);
            }
            return classes2[classes2.length - 1].getIcon(flags);
        }
        return baseIcon;
    }
}

