/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.util.messages.MessageBus;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@State(name="RecentDirectoryProjectsManager", storages={@Storage(value="recentProjectDirectories.xml", roamingType=RoamingType.DISABLED), @Storage(value="other.xml", deprecated=true)})
public class RecentDirectoryProjectsManager
extends RecentProjectsManagerBase {
    public RecentDirectoryProjectsManager(MessageBus messageBus) {
        super(messageBus);
    }

    @Override
    @Nullable
    protected @SystemIndependent String getProjectPath(@NotNull Project project2) {
        ProjectBaseDirectory baseDir;
        if (project2 == null) {
            RecentDirectoryProjectsManager.$$$reportNull$$$0(0);
        }
        VirtualFile baseDirVFile = (baseDir = ProjectBaseDirectory.getInstance(project2)).getBaseDir() != null ? baseDir.getBaseDir() : project2.getBaseDir();
        return baseDirVFile != null ? baseDirVFile.getPath() : null;
    }

    @Override
    protected void doOpenProject(@NotNull @SystemIndependent String projectPath, Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile projectDir;
        if (projectPath == null) {
            RecentDirectoryProjectsManager.$$$reportNull$$$0(1);
        }
        if ((projectDir = LocalFileSystem.getInstance().findFileByPath(projectPath)) != null) {
            EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.of(PlatformProjectOpenProcessor.Option.REOPEN);
            if (forceOpenInNewFrame) {
                options.add(PlatformProjectOpenProcessor.Option.FORCE_NEW_FRAME);
            }
            PlatformProjectOpenProcessor.doOpenProject(projectDir, projectToClose, -1, null, options);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/RecentDirectoryProjectsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

