/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFileFromTemplateAction
extends CreateFromTemplateAction<PsiFile> {
    public CreateFileFromTemplateAction(String text2, String description, Icon icon) {
        super(text2, description, icon);
    }

    protected PsiFile createFileFromTemplate(String name2, FileTemplate template, PsiDirectory dir) {
        return CreateFileFromTemplateAction.createFileFromTemplate(name2, template, dir, this.getDefaultTemplateProperty(), true);
    }

    @Nullable
    public static PsiFile createFileFromTemplate(@Nullable String name2, @NotNull FileTemplate template, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty, boolean openFile2) {
        if (template == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(1);
        }
        return CreateFileFromTemplateAction.createFileFromTemplate(name2, template, dir, defaultTemplateProperty, openFile2, Collections.emptyMap());
    }

    @Nullable
    public static PsiFile createFileFromTemplate(@Nullable String name2, @NotNull FileTemplate template, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty, boolean openFile2, @NotNull Map<String, String> liveTemplateDefaultValues) {
        if (template == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(2);
        }
        if (dir == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(3);
        }
        if (liveTemplateDefaultValues == null) {
            CreateFileFromTemplateAction.$$$reportNull$$$0(4);
        }
        if (name2 != null) {
            CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(name2, dir);
            name2 = mkdirs.newName;
            dir = mkdirs.directory;
        }
        Project project2 = dir.getProject();
        try {
            PsiFile psiFile = FileTemplateUtil.createFromTemplate(template, name2, FileTemplateManager.getInstance(dir.getProject()).getDefaultProperties(), dir).getContainingFile();
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)psiFile);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                if (openFile2) {
                    if (template.isLiveTemplateEnabled()) {
                        CreateFromTemplateActionBase.startLiveTemplate(psiFile, liveTemplateDefaultValues);
                    } else {
                        FileEditorManager.getInstance((Project)project2).openFile(virtualFile, true);
                    }
                }
                if (defaultTemplateProperty != null) {
                    PropertiesComponent.getInstance((Project)project2).setValue(defaultTemplateProperty, template.getName());
                }
                return (PsiFile)pointer.getElement();
            }
        }
        catch (ParseException e) {
            throw new IncorrectOperationException("Error parsing Velocity template: " + e.getMessage(), (Throwable)e);
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    protected PsiFile createFile(String name2, String templateName, PsiDirectory dir) {
        FileTemplate template = FileTemplateManager.getInstance(dir.getProject()).getInternalTemplate(templateName);
        return this.createFileFromTemplate(name2, template, dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "template";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "dir";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "liveTemplateDefaultValues";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/CreateFileFromTemplateAction";
        objectArray[2] = "createFileFromTemplate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

