/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;

public class JumpToLastWindowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx(project2);
        String id = manager.getLastActiveToolWindowId();
        if (id == null || !manager.getToolWindow(id).isAvailable()) {
            return;
        }
        manager.getToolWindow(id).activate(null);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = event.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindowManagerEx manager = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project2);
        String id = manager.getLastActiveToolWindowId();
        presentation.setEnabled(id != null && manager.getToolWindow(id).isAvailable());
    }
}

