/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSettings;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.InputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J<\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0013H\u0014J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J@\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherImpl;", "Lcom/intellij/ide/browsers/BrowserLauncherAppless;", "()V", "browseUsingNotSystemDefaultBrowserPolicy", "", "url", "", "settings", "Lcom/intellij/ide/GeneralSettings;", "project", "Lcom/intellij/openapi/project/Project;", "checkCreatedProcess", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "process", "Ljava/lang/Process;", "launchTask", "Lkotlin/Function0;", "getEffectiveBrowser", "showError", "error", "title", "signUrl", "xml"})
public final class BrowserLauncherImpl
extends BrowserLauncherAppless {
    @Nullable
    protected WebBrowser getEffectiveBrowser(@Nullable WebBrowser browser) {
        WebBrowserManager browserManager;
        WebBrowser effectiveBrowser = browser;
        if (browser == null && Intrinsics.areEqual((Object)((Object)(browserManager = WebBrowserManager.getInstance()).getDefaultBrowserPolicy()), (Object)((Object)DefaultBrowserPolicy.FIRST))) {
            effectiveBrowser = browserManager.getFirstActiveBrowser();
        }
        return effectiveBrowser;
    }

    @NotNull
    protected String signUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String url2 = url;
        BuiltInServerManager serverManager = BuiltInServerManager.getInstance();
        Url parsedUrl = Urls.parse(url2, false);
        if (parsedUrl != null && serverManager.isOnBuiltInWebServer(parsedUrl)) {
            if (Registry.is((String)"ide.built.in.web.server.activatable", (boolean)false)) {
                PropertiesComponent.getInstance().setValue("ide.built.in.web.server.active", true);
            }
            String string = serverManager.addAuthToken(parsedUrl).toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"serverManager.addAuthTok\u2026rsedUrl).toExternalForm()");
            url2 = string;
        }
        return url2;
    }

    protected void browseUsingNotSystemDefaultBrowserPolicy(@NotNull String url, @NotNull GeneralSettings settings, @Nullable Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        if (Intrinsics.areEqual((Object)((Object)browserManager.getDefaultBrowserPolicy()), (Object)((Object)DefaultBrowserPolicy.FIRST))) {
            WebBrowser webBrowser = browserManager.getFirstActiveBrowser();
            if (webBrowser != null) {
                WebBrowser webBrowser2;
                WebBrowser it = webBrowser2 = webBrowser;
                this.browse(url, it, project2);
                return;
            }
        } else if (SystemInfo.isMac && Intrinsics.areEqual((Object)"open", (Object)settings.getBrowserPath())) {
            WebBrowser webBrowser = browserManager.getFirstActiveBrowser();
            if (webBrowser != null) {
                WebBrowser webBrowser3;
                WebBrowser it = webBrowser3 = webBrowser;
                BrowserLauncher.browseUsingPath$default((BrowserLauncher)this, (String)url, null, (WebBrowser)it, (Project)project2, null, (int)16, null);
                return;
            }
        }
        super.browseUsingNotSystemDefaultBrowserPolicy(url, settings, project2);
    }

    protected void showError(@Nullable String error, @Nullable WebBrowser browser, @Nullable Project project2, @Nullable String title, @Nullable Function0<Unit> launchTask) {
        Project project3 = project2;
        AppUIUtil.invokeOnEdt(new Runnable(title, error, project2, browser, launchTask){
            final /* synthetic */ String $title;
            final /* synthetic */ String $error;
            final /* synthetic */ Project $project;
            final /* synthetic */ WebBrowser $browser;
            final /* synthetic */ Function0 $launchTask;

            public final void run() {
                block6: {
                    Runnable runnable2;
                    String string;
                    String string2 = this.$title;
                    if (string2 == null) {
                        String string3 = IdeBundle.message((String)"browser.error", (Object[])new Object[0]);
                        string2 = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"browser.error\")");
                    }
                    if ((string = this.$error) == null) {
                        string = "Unknown error";
                    }
                    String string4 = IdeBundle.message((String)"button.fix", (Object[])new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"IdeBundle.message(\"button.fix\")");
                    if (MessageUtil.showOkNoDialog$default((String)string2, (String)string, (Project)this.$project, null, (String)string4, null, (int)40, null)) break block6;
                    BrowserSettings browserSettings = new BrowserSettings();
                    ShowSettingsUtil showSettingsUtil = ShowSettingsUtil.getInstance();
                    Project project2 = this.$project;
                    Configurable configurable = (Configurable)browserSettings;
                    WebBrowser webBrowser = this.$browser;
                    if (webBrowser != null) {
                        WebBrowser webBrowser2 = webBrowser;
                        Configurable configurable2 = configurable;
                        Project project3 = project2;
                        ShowSettingsUtil showSettingsUtil2 = showSettingsUtil;
                        WebBrowser it = webBrowser2;
                        Runnable runnable3 = new Runnable(it, browserSettings){
                            final /* synthetic */ WebBrowser $it;
                            final /* synthetic */ BrowserSettings $browserSettings$inlined;
                            {
                                this.$it = webBrowser;
                                this.$browserSettings$inlined = browserSettings;
                            }

                            public final void run() {
                                this.$browserSettings$inlined.selectBrowser(this.$it);
                            }
                        };
                        showSettingsUtil = showSettingsUtil2;
                        project2 = project3;
                        configurable = configurable2;
                        runnable2 = runnable3;
                    } else {
                        runnable2 = null;
                    }
                    if (showSettingsUtil.editConfigurable(project2, configurable, runnable2)) {
                        Function0 function0 = this.$launchTask;
                        if (function0 != null) {
                            Unit cfr_ignored_0 = (Unit)function0.invoke();
                        }
                    }
                }
            }
            {
                this.$title = string;
                this.$error = string2;
                this.$project = project2;
                this.$browser = webBrowser;
                this.$launchTask = function0;
            }
        }, (Condition)(project3 != null ? project3.getDisposed() : null));
    }

    protected void checkCreatedProcess(@Nullable WebBrowser browser, @Nullable Project project2, @NotNull GeneralCommandLine commandLine, @NotNull Process process2, @Nullable Function0<Unit> launchTask) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        if (BrowserLauncherAppless.Companion.isOpenCommandUsed(commandLine)) {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, process2, browser, project2, launchTask){
                final /* synthetic */ BrowserLauncherImpl this$0;
                final /* synthetic */ Process $process;
                final /* synthetic */ WebBrowser $browser;
                final /* synthetic */ Project $project;
                final /* synthetic */ Function0 $launchTask;

                public final void run() {
                    try {
                        if (this.$process.waitFor() == 1) {
                            this.this$0.showError(ExecUtil.readFirstLine((InputStream)this.$process.getErrorStream(), null), this.$browser, this.$project, null, (Function0<Unit>)this.$launchTask);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                {
                    this.this$0 = browserLauncherImpl;
                    this.$process = process2;
                    this.$browser = webBrowser;
                    this.$project = project2;
                    this.$launchTask = function0;
                }
            });
            JobScheduler.getScheduler().schedule(new Runnable(future2){
                final /* synthetic */ Future $future;

                public final void run() {
                    this.$future.cancel(true);
                }
                {
                    this.$future = future2;
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }
}

