/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.Url;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "chooseUrl", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/util/Url;", "urls", "", "createRequest", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "xml"})
public final class BaseOpenInBrowserActionKt {
    private static final Logger LOG = Logger.getInstance(BaseOpenInBrowserAction.class);

    private static final OpenInBrowserRequest createRequest(DataContext context) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null) {
            Project project2 = editor.getProject();
            if (project2 != null && project2.isInitialized()) {
                PsiFile psiFile;
                PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
                if (psiFile2 == null) {
                    psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
                }
                if (psiFile != null && !(psiFile.getVirtualFile() instanceof ContentRevisionVirtualFile)) {
                    return new OpenInBrowserRequest(editor, psiFile, psiFile){
                        static final /* synthetic */ KProperty[] $$delegatedProperties;
                        private final Lazy _element$delegate;
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ PsiFile $psiFile;

                        static {
                            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(createRequest.1.class), "_element", "get_element()Lcom/intellij/psi/PsiElement;"))};
                        }

                        private final PsiElement get_element() {
                            Lazy lazy = this._element$delegate;
                            createRequest.1 var2_2 = this;
                            KProperty kProperty = $$delegatedProperties[0];
                            return (PsiElement)lazy.getValue();
                        }

                        @NotNull
                        public PsiElement getElement() {
                            PsiElement psiElement = this.get_element();
                            if (psiElement == null) {
                                psiElement = (PsiElement)this.getFile();
                            }
                            return psiElement;
                        }
                        {
                            this.$editor = $captured_local_variable$0;
                            this.$psiFile = $captured_local_variable$1;
                            super($super_call_param$2);
                            this._element$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiElement>(this){
                                final /* synthetic */ createRequest.1 this$0;

                                @Nullable
                                public final PsiElement invoke() {
                                    return this.this$0.getFile().findElementAt(this.this$0.$editor.getCaretModel().getOffset());
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                    };
                }
            }
        } else {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
            Project project3 = (Project)CommonDataKeys.PROJECT.getData(context);
            if (virtualFile != null && !virtualFile.isDirectory() && virtualFile.isValid() && project3 != null && project3.isInitialized()) {
                psiFile = PsiManager.getInstance((Project)project3).findFile(virtualFile);
            }
            if (psiFile != null && !(psiFile.getVirtualFile() instanceof ContentRevisionVirtualFile)) {
                return OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)((PsiElement)psiFile));
            }
        }
        return null;
    }

    private static final Promise<Url> chooseUrl(Collection<? extends Url> urls) {
        if (urls.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)urls));
        }
        JBList list2 = new JBList(urls);
        list2.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Url>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Url> list2, @Nullable Url value2, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                this.setIcon(AllIcons.Nodes.Servlet);
                Url url = value2;
                if (url == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Url");
                }
                this.append(url.toDecodedForm());
            }
        });
        AsyncPromise result2 = new AsyncPromise();
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Choose Url").setItemChoosenCallback(new Runnable(list2, result2){
            final /* synthetic */ JBList $list;
            final /* synthetic */ AsyncPromise $result;

            public final void run() {
                Url value2 = (Url)this.$list.getSelectedValue();
                if (value2 == null) {
                    this.$result.setError("selected value is null");
                } else {
                    this.$result.setResult((Object)value2);
                }
            }
            {
                this.$list = jBList;
                this.$result = asyncPromise;
            }
        }).createPopup().showInFocusCenter();
        return (Promise)result2;
    }

    @Nullable
    public static final /* synthetic */ OpenInBrowserRequest access$createRequest(@NotNull DataContext context) {
        return BaseOpenInBrowserActionKt.createRequest(context);
    }

    @NotNull
    public static final /* synthetic */ Promise access$chooseUrl(@NotNull Collection urls) {
        return BaseOpenInBrowserActionKt.chooseUrl(urls);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

