/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class ExporterToTextFileHierarchy
implements ExporterToTextFile {
    private static final Logger LOG = Logger.getInstance(ExporterToTextFileHierarchy.class);
    private final HierarchyBrowserBase myHierarchyBrowserBase;

    public ExporterToTextFileHierarchy(@NotNull HierarchyBrowserBase hierarchyBrowserBase) {
        if (hierarchyBrowserBase == null) {
            ExporterToTextFileHierarchy.$$$reportNull$$$0(0);
        }
        this.myHierarchyBrowserBase = hierarchyBrowserBase;
    }

    public JComponent getSettingsEditor() {
        return null;
    }

    public void addSettingsChangedListener(ChangeListener listener2) throws TooManyListenersException {
    }

    public void removeSettingsChangedListener(ChangeListener listener2) {
    }

    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        HierarchyTreeBuilder currentBuilder = this.myHierarchyBrowserBase.getCurrentBuilder();
        LOG.assertTrue(currentBuilder != null);
        this.appendNode(buf, currentBuilder.getRootNode(), SystemProperties.getLineSeparator(), "");
        String string = buf.toString();
        if (string == null) {
            ExporterToTextFileHierarchy.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void appendNode(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator, String indent) {
        String childIndent;
        if (node.getParent() != null) {
            childIndent = indent + "    ";
            HierarchyNodeDescriptor descriptor2 = this.myHierarchyBrowserBase.getDescriptor(node);
            if (descriptor2 != null) {
                buf.append(indent).append(descriptor2.getHighlightedText().getText()).append(lineSeparator);
            }
        } else {
            childIndent = indent;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child, lineSeparator, childIndent);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        String string = state != null && state.EXPORT_FILE_PATH != null ? state.EXPORT_FILE_PATH : "";
        if (string == null) {
            ExporterToTextFileHierarchy.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void exportedTo(String filePath) {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        if (state != null) {
            state.EXPORT_FILE_PATH = filePath;
        }
    }

    public boolean canExport() {
        return this.myHierarchyBrowserBase.getCurrentBuilder() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyBrowserBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/ExporterToTextFileHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/ExporterToTextFileHierarchy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

