/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.TypeHierarchyBrowser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSyntheticClass;
import org.jetbrains.annotations.NotNull;

public class JavaTypeHierarchyProvider
implements HierarchyProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider");

    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Project project2;
        if (dataContext == null) {
            JavaTypeHierarchyProvider.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("editor " + editor);
        }
        if (editor != null) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return null;
            }
            PsiElement targetElement = TargetElementUtil.findTargetElement(editor, 11);
            if (LOG.isDebugEnabled()) {
                LOG.debug("target element " + targetElement);
            }
            if (targetElement instanceof PsiClass) {
                return targetElement;
            }
            int offset = editor.getCaretModel().getOffset();
            for (PsiElement element = file2.findElementAt(offset); element != null; element = element.getParent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("context element " + element);
                }
                if (element instanceof PsiFile) {
                    if (!(element instanceof PsiClassOwner)) {
                        return null;
                    }
                    PsiClass[] classes2 = ((PsiClassOwner)element).getClasses();
                    return classes2.length == 1 ? classes2[0] : null;
                }
                if (!(element instanceof PsiClass) || element instanceof PsiAnonymousClass || element instanceof PsiSyntheticClass) continue;
                return element;
            }
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return element instanceof PsiClass ? (PsiClass)element : null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target2) {
        TypeHierarchyBrowser typeHierarchyBrowser = new TypeHierarchyBrowser(target2.getProject(), (PsiClass)target2);
        if (typeHierarchyBrowser == null) {
            JavaTypeHierarchyProvider.$$$reportNull$$$0(1);
        }
        return typeHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        TypeHierarchyBrowser browser;
        if (hierarchyBrowser == null) {
            JavaTypeHierarchyProvider.$$$reportNull$$$0(2);
        }
        String typeName = (browser = (TypeHierarchyBrowser)hierarchyBrowser).isInterface() ? TypeHierarchyBrowserBase.SUBTYPES_HIERARCHY_TYPE : TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE;
        browser.changeView(typeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHierarchyBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "browserActivated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

