/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.CannotConvertException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class JDomConvertingUtil
extends JDomSerializationUtil {
    private JDomConvertingUtil() {
    }

    public static Document loadDocument(File file2) throws CannotConvertException {
        try {
            return JDOMUtil.loadDocument((File)file2);
        }
        catch (IOException | JDOMException e) {
            throw new CannotConvertException(file2.getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    public static String getOptionValue(Element element, String optionName) {
        return JDOMExternalizerUtil.readField((Element)element, (String)optionName);
    }

    @Nullable
    public static String getSettingsValue(@Nullable Element element) {
        return element != null ? element.getAttributeValue("value") : null;
    }

    @Nullable
    public static Element getSettingsElement(@Nullable Element element, String name2) {
        for (Element child : JDOMUtil.getChildren((Element)element, (String)"setting")) {
            if (!child.getAttributeValue("name").equals(name2)) continue;
            return child;
        }
        return null;
    }

    public static Condition<Element> createAttributeValueFilter(@NonNls String name2, @NonNls String value2) {
        return JDomConvertingUtil.createAttributeValueFilter(name2, Collections.singleton(value2));
    }

    public static Condition<Element> createAttributeValueFilter(@NonNls String name2, @NonNls Collection<String> value2) {
        return element -> value2.contains(element.getAttributeValue(name2));
    }

    public static Condition<Element> createOptionElementFilter(@NonNls String optionName) {
        return JDomConvertingUtil.createElementWithAttributeFilter("option", "name", optionName);
    }

    public static Condition<Element> createElementWithAttributeFilter(String elementName, String attributeName, String attributeValue) {
        return Conditions.and(JDomConvertingUtil.createElementNameFilter(elementName), JDomConvertingUtil.createAttributeValueFilter(attributeName, attributeValue));
    }

    public static void copyAttributes(Element from, Element to) {
        List attributes = from.getAttributes();
        for (Attribute attribute : attributes) {
            to.setAttribute(attribute.getName(), attribute.getValue());
        }
    }

    public static void copyChildren(Element from, Element to) {
        JDomConvertingUtil.copyChildren(from, to, (Condition<Element>)Conditions.alwaysTrue());
    }

    public static void copyChildren(Element from, Element to, Condition<Element> filter2) {
        List list2 = from.getChildren();
        for (Element element : list2) {
            if (!filter2.value((Object)element)) continue;
            to.addContent(element.clone());
        }
    }

    public static Condition<Element> createElementNameFilter(@NonNls String elementName) {
        return element -> elementName.equals(element.getName());
    }

    public static List<Element> removeChildren(Element element, Condition<Element> filter2) {
        ArrayList<Element> toRemove2 = new ArrayList<Element>();
        List list2 = element.getChildren();
        for (Element e : list2) {
            if (!filter2.value((Object)e)) continue;
            toRemove2.add(e);
        }
        for (Element e : toRemove2) {
            element.removeContent((Content)e);
        }
        return toRemove2;
    }

    public static Element createOptionElement(String name2, String value2) {
        Element element = new Element("option");
        element.setAttribute("name", name2);
        element.setAttribute("value", value2);
        return element;
    }

    @Nullable
    public static Element findChild(Element parent, Condition<Element> filter2) {
        List list2 = parent.getChildren();
        for (Element e : list2) {
            if (!filter2.value((Object)e)) continue;
            return e;
        }
        return null;
    }

    public static void removeDuplicatedOptions(Element element) {
        ArrayList children2 = new ArrayList(element.getChildren("option"));
        HashSet<String> names = new HashSet<String>();
        for (Element child : children2) {
            if (names.add(child.getAttributeValue("name"))) continue;
            element.removeContent((Content)child);
        }
    }
}

