/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.InternalModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNavBarExtension
extends AbstractNavBarModelExtension {
    @Override
    @Nullable
    public String getPresentableText(Object object) {
        if (object instanceof Project) {
            return ((Project)object).getName();
        }
        if (object instanceof Module) {
            return ((Module)object).getName();
        }
        if (object instanceof PsiFile) {
            VirtualFile file2 = ((PsiFile)object).getVirtualFile();
            return file2 != null ? file2.getPresentableName() : ((PsiFile)object).getName();
        }
        if (object instanceof PsiDirectory) {
            return ((PsiDirectory)object).getVirtualFile().getName();
        }
        if (object instanceof JdkOrderEntry) {
            return ((JdkOrderEntry)object).getJdkName();
        }
        if (object instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)object).getLibraryName();
            return libraryName != null ? libraryName : AnalysisScopeBundle.message((String)"package.dependencies.library.node.text", (Object[])new Object[0]);
        }
        if (object instanceof ModuleOrderEntry) {
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)object;
            return moduleOrderEntry.getModuleName();
        }
        return null;
    }

    @Override
    public PsiElement adjustElement(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            return containingFile;
        }
        return psiElement;
    }

    @Override
    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor2) {
        if (object instanceof Project) {
            return DefaultNavBarExtension.processChildren((Project)object, processor2);
        }
        if (object instanceof Module) {
            return DefaultNavBarExtension.processChildren((Module)object, processor2);
        }
        if (object instanceof PsiDirectoryContainer) {
            PsiDirectory[] psiDirectories;
            PsiDirectoryContainer psiPackage = (PsiDirectoryContainer)object;
            for (PsiDirectory psiDirectory : psiDirectories = (PsiDirectory[])ReadAction.compute(() -> rootElement instanceof Module ? psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)((Module)rootElement))) : psiPackage.getDirectories())) {
                if (DefaultNavBarExtension.processChildren(psiDirectory, rootElement, processor2)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof PsiDirectory) {
            return DefaultNavBarExtension.processChildren((PsiDirectory)object, rootElement, processor2);
        }
        if (object instanceof PsiFileSystemItem) {
            return DefaultNavBarExtension.processChildren((PsiFileSystemItem)object, processor2);
        }
        return true;
    }

    private static boolean processChildren(Project object, Processor<Object> processor2) {
        return (Boolean)ReadAction.compute(() -> {
            for (Module module2 : ModuleManager.getInstance((Project)object).getModules()) {
                if (ModuleType.get((Module)module2) instanceof InternalModuleType || processor2.process((Object)module2)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean processChildren(Module module2, Processor<Object> processor2) {
        VirtualFile[] roots;
        PsiManager psiManager = PsiManager.getInstance((Project)module2.getProject());
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        for (VirtualFile root : roots = moduleRootManager.getContentRoots()) {
            PsiDirectory psiDirectory = (PsiDirectory)ReadAction.compute(() -> psiManager.findDirectory(root));
            if (psiDirectory == null || processor2.process((Object)psiDirectory)) continue;
            return false;
        }
        return true;
    }

    private static boolean processChildren(PsiDirectory object, Object rootElement, Processor<Object> processor2) {
        return (Boolean)ReadAction.compute(() -> {
            PsiElement[] children2;
            ModuleFileIndex moduleFileIndex = rootElement instanceof Module ? ModuleRootManager.getInstance((Module)((Module)rootElement)).getFileIndex() : null;
            for (PsiElement child : children2 = object.getChildren()) {
                VirtualFile virtualFile;
                if (child == null || !child.isValid() || moduleFileIndex != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)child)) != null && !moduleFileIndex.isInContent(virtualFile) || processor2.process((Object)child)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean processChildren(PsiFileSystemItem object, final Processor<Object> processor2) {
        return (Boolean)ReadAction.compute(() -> object.processChildren((PsiElementProcessor)new PsiFileSystemItemProcessor(){

            @Override
            public boolean acceptItem(String name2, boolean isDirectory) {
                return true;
            }

            public boolean execute(@NotNull PsiFileSystemItem element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processor2.process((Object)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/navigationToolbar/DefaultNavBarExtension$1", "execute"));
            }
        }));
    }

    @Override
    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            if (containingDirectory != null) {
                return containingDirectory;
            }
        } else {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)psiElement;
                Project project2 = psiElement.getProject();
                PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
                if (parentDirectory == null) {
                    VirtualFile jar = VfsUtil.getLocalFile((VirtualFile)psiDirectory.getVirtualFile());
                    if (ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(jar)) {
                        parentDirectory = PsiManager.getInstance((Project)project2).findDirectory(jar.getParent());
                    }
                }
                return parentDirectory;
            }
            if (psiElement instanceof PsiFileSystemItem) {
                PsiDirectory parentDirectory;
                VirtualFile virtualFile = ((PsiFileSystemItem)psiElement).getVirtualFile();
                if (virtualFile == null) {
                    return null;
                }
                PsiManager psiManager = psiElement.getManager();
                Object resultElement = virtualFile.isDirectory() ? psiManager.findDirectory(virtualFile) : psiManager.findFile(virtualFile);
                if (resultElement == null) {
                    return null;
                }
                VirtualFile parentVFile = virtualFile.getParent();
                if (parentVFile != null && (parentDirectory = psiManager.findDirectory(parentVFile)) != null) {
                    return parentDirectory;
                }
            }
        }
        return null;
    }
}

