/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNestingRulesProvider;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectViewFileNesting", storages={@Storage(value="ui.lnf.xml")})
public class ProjectViewFileNestingService
implements PersistentStateComponent<MyState>,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(ProjectViewFileNestingService.class);
    private static final ExtensionPointName<ProjectViewNestingRulesProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewNestingRulesProvider");
    public static final NestingRule[] DEFAULT_NESTING_RULES = ProjectViewFileNestingService.loadDefaultNestingRules();
    private MyState myState = new MyState();
    private long myModCount = 0L;

    @NotNull
    public static ProjectViewFileNestingService getInstance() {
        ProjectViewFileNestingService projectViewFileNestingService = (ProjectViewFileNestingService)ServiceManager.getService(ProjectViewFileNestingService.class);
        if (projectViewFileNestingService == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(0);
        }
        return projectViewFileNestingService;
    }

    @NotNull
    private static NestingRule[] loadDefaultNestingRules() {
        SortedList result2 = new SortedList(Comparator.comparing(o -> o.getParentFileSuffix()));
        ProjectViewNestingRulesProvider.Consumer consumer = new ProjectViewNestingRulesProvider.Consumer((List)result2){
            final /* synthetic */ List val$result;
            {
                this.val$result = list2;
            }

            public void addNestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
                if (parentFileSuffix == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (childFileSuffix == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.assertTrue(!parentFileSuffix.isEmpty() && !childFileSuffix.isEmpty(), (Object)"file suffix must not be empty");
                LOG.assertTrue(!parentFileSuffix.equals(childFileSuffix), (Object)("parent and child suffixes must be different: " + parentFileSuffix));
                this.val$result.add(new NestingRule(parentFileSuffix, childFileSuffix));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parentFileSuffix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "childFileSuffix";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$1";
                objectArray[2] = "addNestingRule";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (ProjectViewNestingRulesProvider provider : (ProjectViewNestingRulesProvider[])EP_NAME.getExtensions()) {
            provider.addFileNestingRules(consumer);
        }
        NestingRule[] nestingRuleArray = result2.toArray(new NestingRule[0]);
        if (nestingRuleArray == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(1);
        }
        return nestingRuleArray;
    }

    public MyState getState() {
        return this.myState;
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(2);
        }
        this.myState = state;
        ++this.myModCount;
    }

    @NotNull
    public List<NestingRule> getRules() {
        List<NestingRule> list2 = this.myState.myRules;
        if (list2 == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void setRules(@NotNull List<NestingRule> rules) {
        if (rules == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(4);
        }
        this.myState.myRules.clear();
        this.myState.myRules.addAll(rules);
        ++this.myModCount;
    }

    public long getModificationCount() {
        return this.myModCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultNestingRules";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NestingRule {
        @NotNull
        private String myParentFileSuffix;
        @NotNull
        private String myChildFileSuffix;

        public NestingRule() {
            this("", "");
        }

        public NestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
            if (parentFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(0);
            }
            if (childFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(1);
            }
            this.myParentFileSuffix = parentFileSuffix;
            this.myChildFileSuffix = childFileSuffix;
        }

        @Attribute(value="parent-file-suffix")
        @NotNull
        public String getParentFileSuffix() {
            String string = this.myParentFileSuffix;
            if (string == null) {
                NestingRule.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setParentFileSuffix(@NotNull String parentFileSuffix) {
            if (parentFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(3);
            }
            this.myParentFileSuffix = parentFileSuffix;
        }

        @Attribute(value="child-file-suffix")
        @NotNull
        public String getChildFileSuffix() {
            String string = this.myChildFileSuffix;
            if (string == null) {
                NestingRule.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void setChildFileSuffix(@NotNull String childFileSuffix) {
            if (childFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(5);
            }
            this.myChildFileSuffix = childFileSuffix;
        }

        public String toString() {
            return this.myParentFileSuffix + "->" + this.myChildFileSuffix;
        }

        public boolean equals(Object o) {
            return o instanceof NestingRule && this.myParentFileSuffix.equals(((NestingRule)o).myParentFileSuffix) && this.myChildFileSuffix.equals(((NestingRule)o).myChildFileSuffix);
        }

        public int hashCode() {
            return this.myParentFileSuffix.hashCode() + 239 * this.myChildFileSuffix.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFileSuffix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childFileSuffix";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentFileSuffix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildFileSuffix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setParentFileSuffix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildFileSuffix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyState {
        @Tag(value="nesting-rules")
        @AbstractCollection(surroundWithTag=false)
        public List<NestingRule> myRules = new SortedList(Comparator.comparing(o -> o.getParentFileSuffix()));

        public MyState() {
            this.myRules.addAll(Arrays.asList(DEFAULT_NESTING_RULES));
        }
    }
}

