/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsiBasedNode<Value>
extends ProjectViewNode<Value>
implements ValidateableNode,
StatePreservingNavigatable {
    private static final Logger LOG = Logger.getInstance((String)AbstractPsiBasedNode.class.getName());

    protected AbstractPsiBasedNode(Project project2, Value value2, ViewSettings viewSettings) {
        super(project2, value2, viewSettings);
    }

    @Nullable
    protected abstract PsiElement extractPsiFromValue();

    @Nullable
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected abstract void updateImpl(PresentationData var1);

    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>();
            if (arrayList == null) {
                AbstractPsiBasedNode.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        boolean valid = psiElement.isValid();
        if (!LOG.assertTrue(valid)) {
            List<AbstractTreeNode> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractPsiBasedNode.$$$reportNull$$$0(1);
            }
            return list2;
        }
        Collection<AbstractTreeNode> children2 = this.getChildrenImpl();
        Collection<Object> collection = children2 != null ? children2 : Collections.emptyList();
        if (collection == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }

    protected boolean isMarkReadOnly() {
        AbstractTreeNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof AbstractPsiBasedNode) {
            PsiElement psiElement = ((AbstractPsiBasedNode)parent).extractPsiFromValue();
            return psiElement instanceof PsiDirectory;
        }
        Object parentValue = parent.getValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof Module;
    }

    public FileStatus getFileStatus() {
        VirtualFile file2 = this.getVirtualFileForValue();
        if (file2 == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)this.getProject()).getStatus(file2);
    }

    @Nullable
    private VirtualFile getVirtualFileForValue() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return null;
        }
        return PsiUtilBase.getVirtualFile((PsiElement)psiElement);
    }

    public void update(PresentationData data) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!this.validate()) {
                return;
            }
            PsiElement value2 = this.extractPsiFromValue();
            LOG.assertTrue(value2.isValid());
            int flags = this.getIconableFlags();
            try {
                Icon icon = value2.getIcon(flags);
                data.setIcon(icon);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            data.setPresentableText(this.myName);
            try {
                if (this.isDeprecated()) {
                    data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            this.updateImpl(data);
            data.setIcon(AbstractPsiBasedNode.patchIcon(this.myProject, data.getIcon(true), this.getVirtualFile()));
            for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
                try {
                    decorator.decorate(this, data);
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        });
    }

    @Iconable.IconFlags
    protected int getIconableFlags() {
        int flags;
        int n = flags = Registry.is((String)"ide.projectView.show.visibility") ? 1 : 0;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        return flags;
    }

    @Nullable
    public static Icon patchIcon(@NotNull Project project2, @Nullable Icon original, @Nullable VirtualFile file2) {
        if (project2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(3);
        }
        if (file2 == null || original == null) {
            return original;
        }
        Icon icon = original;
        Bookmark bookmarkAtFile = BookmarkManager.getInstance(project2).findFileBookmark(file2);
        if (bookmarkAtFile != null) {
            RowIcon composite = new RowIcon(2, RowIcon.Alignment.CENTER);
            composite.setIcon(icon, 0);
            composite.setIcon(bookmarkAtFile.getIcon(), 1);
            icon = composite;
        }
        if (!file2.isWritable()) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.LOCKED_ICON);
        }
        if (file2.is(VFileProperty.SYMLINK)) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.SYMLINK_ICON);
        }
        return icon;
    }

    protected boolean isDeprecated() {
        return false;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        PsiElement psiElement;
        if (file2 == null) {
            AbstractPsiBasedNode.$$$reportNull$$$0(4);
        }
        if ((psiElement = this.extractPsiFromValue()) == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile valueFile = containingFile.getVirtualFile();
        return valueFile != null && file2.equals(valueFile);
    }

    @Nullable
    public NavigationItem getNavigationItem() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement instanceof NavigationItem ? (NavigationItem)psiElement : null;
    }

    public void navigate(boolean requestFocus, boolean preserveState) {
        if (this.canNavigate()) {
            if (requestFocus || preserveState) {
                NavigationUtil.openFileWithPsiElement(this.extractPsiFromValue(), requestFocus, requestFocus);
            } else {
                this.getNavigationItem().navigate(requestFocus);
            }
        }
    }

    public void navigate(boolean requestFocus) {
        this.navigate(requestFocus, false);
    }

    public boolean canNavigate() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigate();
    }

    public boolean canNavigateToSource() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigateToSource();
    }

    @Nullable
    protected String calcTooltip() {
        return null;
    }

    public boolean validate() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "patchIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

