/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleGroupNode
extends ProjectViewNode<ModuleGroup>
implements DropTargetNode {
    public ModuleGroupNode(Project project2, ModuleGroup value2, ViewSettings viewSettings) {
        super(project2, (Object)value2, viewSettings);
    }

    public ModuleGroupNode(Project project2, Object value2, ViewSettings viewSettings) {
        this(project2, (ModuleGroup)value2, viewSettings);
    }

    protected abstract AbstractTreeNode createModuleNode(Module var1) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    protected abstract ModuleGroupNode createModuleGroupNode(ModuleGroup var1);

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)this.getProject());
        Collection<ModuleGroup> childGroups = ((ModuleGroup)this.getValue()).childGroups(grouper);
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        for (ModuleGroup moduleGroup : childGroups) {
            result2.add((AbstractTreeNode)this.createModuleGroupNode(moduleGroup));
        }
        Collection<Module> modules = ((ModuleGroup)this.getValue()).modulesInGroup(grouper, false);
        try {
            for (Module module2 : modules) {
                result2.add(this.createModuleNode(module2));
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        ArrayList<AbstractTreeNode> arrayList = result2;
        if (arrayList == null) {
            ModuleGroupNode.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Collection<AbstractTreeNode> children2 = this.getChildren();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (AbstractTreeNode each : children2) {
            if (!(each instanceof ProjectViewNode)) continue;
            result2.addAll(((ProjectViewNode)each).getRoots());
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            ModuleGroupNode.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleGroupNode.$$$reportNull$$$0(2);
        }
        List<Module> modules = this.getModulesByFile(file2);
        List<String> thisGroupPath = ((ModuleGroup)this.getValue()).getGroupPathList();
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)this.getProject());
        for (Module module2 : modules) {
            if (!ContainerUtil.startsWith((List)grouper.getGroupPath(module2), thisGroupPath)) continue;
            return true;
        }
        return false;
    }

    public boolean validate() {
        return this.getValue() != null;
    }

    @NotNull
    protected abstract List<Module> getModulesByFile(@NotNull VirtualFile var1);

    public void update(PresentationData presentation) {
        presentation.setPresentableText(this.getPresentableName());
        presentation.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
    }

    @NotNull
    private String getPresentableName() {
        String string = StringUtil.join(this.getRelativeGroupPath(), (String)".");
        if (string == null) {
            ModuleGroupNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    private List<String> getRelativeGroupPath() {
        List<String> parentPath;
        AbstractTreeNode parent = this.getParent();
        List<String> thisPath = ((ModuleGroup)this.getValue()).getGroupPathList();
        if (parent instanceof ModuleGroupNode && ContainerUtil.startsWith(thisPath, parentPath = ((ModuleGroup)((ModuleGroupNode)parent).getValue()).getGroupPathList())) {
            return thisPath.subList(parentPath.size(), thisPath.size());
        }
        return thisPath;
    }

    public String getTestPresentation() {
        return "Group: " + this.getPresentableName();
    }

    public String getToolTip() {
        return IdeBundle.message((String)"tooltip.module.group", (Object[])new Object[0]);
    }

    public int getWeight() {
        return 0;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 1;
    }

    @Override
    public boolean canDrop(TreeNode[] sourceNodes) {
        List<Module> modules = ModuleGroupNode.extractModules(sourceNodes);
        return !modules.isEmpty();
    }

    @Override
    public void drop(TreeNode[] sourceNodes, DataContext dataContext) {
        List<Module> modules = ModuleGroupNode.extractModules(sourceNodes);
        MoveModulesToGroupAction.doMove(modules.toArray(new Module[modules.size()]), (ModuleGroup)this.getValue(), null);
    }

    @Override
    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext) {
    }

    private static List<Module> extractModules(TreeNode[] sourceNodes) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (TreeNode sourceNode : sourceNodes) {
            Object userObject;
            if (!(sourceNode instanceof DefaultMutableTreeNode) || !((userObject = AbstractProjectViewPane.extractUserObject((DefaultMutableTreeNode)sourceNode)) instanceof Module)) continue;
            modules.add((Module)userObject);
        }
        return modules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ModuleGroupNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ModuleGroupNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

