/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PackageViewProjectNode
extends AbstractProjectNode {
    public PackageViewProjectNode(Project project2, ViewSettings viewSettings) {
        super(project2, project2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        if (this.getSettings().isShowModules()) {
            ArrayList<ModuleDescription> modulesWithSourceRoots = new ArrayList<ModuleDescription>();
            for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                if (ModuleRootManager.getInstance((Module)module2).getSourceRoots().length <= 0) continue;
                modulesWithSourceRoots.add((ModuleDescription)new LoadedModuleDescriptionImpl(module2));
            }
            Collection<AbstractTreeNode> collection = this.modulesAndGroups(modulesWithSourceRoots);
            if (collection == null) {
                PackageViewProjectNode.$$$reportNull$$$0(0);
            }
            return collection;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : projectRootManager.getContentSourceRoots()) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children2.addAll(ProjectViewDirectoryHelper.getInstance(this.myProject).getDirectoryChildren(directory, this.getSettings(), false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage psiPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children2, psiPackage, null, this.getSettings(), false);
        }
        if (this.getSettings().isShowLibraryContents()) {
            children2.add((AbstractTreeNode)new PackageViewLibrariesNode(this.getProject(), null, this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            PackageViewProjectNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    protected AbstractTreeNode createModuleGroup(Module module2) {
        return new PackageViewModuleNode(this.getProject(), module2, this.getSettings());
    }

    @Override
    protected AbstractTreeNode createModuleGroupNode(ModuleGroup moduleGroup) {
        return new PackageViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    public boolean someChildContainsFile(VirtualFile file2) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageViewProjectNode", "getChildren"));
    }
}

