/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDirectoryNode
extends BasePsiNode<PsiDirectory>
implements NavigatableWithText {
    private final PsiFileSystemItemFilter myFilter;

    public PsiDirectoryNode(Project project2, PsiDirectory value2, ViewSettings viewSettings) {
        this(project2, value2, viewSettings, null);
    }

    public PsiDirectoryNode(Project project2, PsiDirectory value2, ViewSettings viewSettings, @Nullable PsiFileSystemItemFilter filter2) {
        super(project2, value2, viewSettings);
        this.myFilter = filter2;
    }

    @Nullable
    public PsiFileSystemItemFilter getFilter() {
        return this.myFilter;
    }

    protected boolean shouldShowModuleName() {
        return !PlatformUtils.isCidr();
    }

    protected boolean shouldShowSourcesRoot() {
        return true;
    }

    @Override
    protected void updateImpl(PresentationData data) {
        String name2;
        Project project2 = this.getProject();
        assert (project2 != null) : this;
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        assert (psiDirectory != null) : this;
        VirtualFile directoryFile = psiDirectory.getVirtualFile();
        Object parentValue = this.getParentValue();
        if (ProjectRootsUtil.isModuleContentRoot(directoryFile, project2)) {
            ProjectFileIndex fi = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            Module module2 = fi.getModuleForFile(directoryFile);
            data.setPresentableText(directoryFile.getName());
            if (module2 != null) {
                if (!(parentValue instanceof Module)) {
                    if (!this.shouldShowModuleName()) {
                        data.addText(directoryFile.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (PsiDirectoryNode.moduleNameMatchesDirectoryName(module2, directoryFile, fi)) {
                        data.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        data.addText(directoryFile.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        data.addText("[" + module2.getName() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                } else {
                    data.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                boolean shouldShowUrl = parentValue instanceof Module || parentValue instanceof Project;
                data.setLocationString(ProjectViewDirectoryHelper.getInstance(project2).getLocationString(psiDirectory, shouldShowUrl, this.shouldShowSourcesRoot()));
                this.setupIcon(data, psiDirectory);
                return;
            }
        }
        String string = name2 = parentValue instanceof Project ? psiDirectory.getVirtualFile().getPresentableUrl() : ProjectViewDirectoryHelper.getInstance(psiDirectory.getProject()).getNodeName(this.getSettings(), parentValue, psiDirectory);
        if (name2 == null) {
            this.setValue(null);
            return;
        }
        data.setPresentableText(name2);
        data.setLocationString(ProjectViewDirectoryHelper.getInstance(project2).getLocationString(psiDirectory, false, false));
        this.setupIcon(data, psiDirectory);
    }

    private static boolean moduleNameMatchesDirectoryName(@NotNull Module module2, @NotNull VirtualFile directoryFile, @NotNull ProjectFileIndex fileIndex) {
        Module parentModule;
        VirtualFile parentDirectory;
        int parentPrefixLength;
        String directoryName;
        String moduleName;
        if (module2 == null) {
            PsiDirectoryNode.$$$reportNull$$$0(0);
        }
        if (directoryFile == null) {
            PsiDirectoryNode.$$$reportNull$$$0(1);
        }
        if (fileIndex == null) {
            PsiDirectoryNode.$$$reportNull$$$0(2);
        }
        if ((moduleName = module2.getName()).equals(directoryName = directoryFile.getName())) {
            return true;
        }
        return ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)module2.getProject()) && moduleName.endsWith(directoryName) && (parentPrefixLength = moduleName.length() - directoryName.length() - 1) > 0 && moduleName.charAt(parentPrefixLength) == '.' && ProjectRootsUtil.isModuleContentRoot(parentDirectory = directoryFile.getParent(), module2.getProject()) && (parentModule = fileIndex.getModuleForFile(parentDirectory)) != null && parentModule.getName().length() == parentPrefixLength && moduleName.startsWith(parentModule.getName());
    }

    protected void setupIcon(PresentationData data, PsiDirectory psiDirectory) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        if (PlatformUtils.isAppCode()) {
            Icon icon = IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)this.myProject);
            if (icon != null) {
                data.setIcon(icon);
            }
        } else {
            for (IconProvider provider : (IconProvider[])Extensions.getExtensions((ExtensionPointName)IconProvider.EXTENSION_POINT_NAME)) {
                Icon icon = provider.getIcon((PsiElement)psiDirectory, 0);
                if (icon == null) continue;
                data.setIcon(icon);
                return;
            }
        }
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        return ProjectViewDirectoryHelper.getInstance(this.myProject).getDirectoryChildren((PsiDirectory)this.getValue(), this.getSettings(), true, this.getFilter());
    }

    public String getTestPresentation() {
        return "PsiDirectory: " + ((PsiDirectory)this.getValue()).getName();
    }

    public boolean isFQNameShown() {
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).isShowFQName(this.getSettings(), this.getParentValue(), (PsiDirectory)this.getValue());
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        PsiDirectory value2;
        if (file2 == null) {
            PsiDirectoryNode.$$$reportNull$$$0(3);
        }
        if ((value2 = (PsiDirectory)this.getValue()) == null) {
            return false;
        }
        VirtualFile directory = value2.getVirtualFile();
        if (directory.getFileSystem() instanceof LocalFileSystem) {
            file2 = VfsUtil.getLocalFile((VirtualFile)file2);
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)file2, (boolean)false)) {
            return false;
        }
        Project project2 = value2.getProject();
        PsiFileSystemItemFilter filter2 = this.getFilter();
        if (filter2 != null) {
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
            if (psiFile != null && !filter2.shouldShow((PsiFileSystemItem)psiFile)) {
                return false;
            }
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)project2).findDirectory(file2);
            if (psiDirectory != null && !filter2.shouldShow((PsiFileSystemItem)psiDirectory)) {
                return false;
            }
        }
        if (Registry.is((String)"ide.hide.excluded.files")) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            return !fileIndex.isExcluded(file2);
        }
        return !FileTypeRegistry.getInstance().isFileIgnored(file2);
    }

    public VirtualFile getVirtualFile() {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory == null) {
            return null;
        }
        return directory.getVirtualFile();
    }

    public boolean canRepresent(Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory == null) {
            return false;
        }
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).canRepresent(element, directory);
    }

    @Override
    public boolean canNavigate() {
        VirtualFile file2 = this.getVirtualFile();
        Project project2 = this.getProject();
        ProjectSettingsService service = ProjectSettingsService.getInstance(this.myProject);
        return file2 != null && (ProjectRootsUtil.isModuleContentRoot(file2, project2) && service.canOpenModuleSettings() || ProjectRootsUtil.isModuleSourceRoot(file2, project2) && service.canOpenContentEntriesSettings() || ProjectRootsUtil.isLibraryRoot(file2, project2) && service.canOpenModuleLibrarySettings());
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Module module2 = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)this.getValue()));
        if (module2 != null) {
            VirtualFile file2 = this.getVirtualFile();
            Project project2 = this.getProject();
            ProjectSettingsService service = ProjectSettingsService.getInstance(this.myProject);
            if (ProjectRootsUtil.isModuleContentRoot(file2, project2)) {
                service.openModuleSettings(module2);
            } else if (ProjectRootsUtil.isLibraryRoot(file2, project2)) {
                OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)file2, (Project)module2.getProject());
                if (orderEntry != null) {
                    service.openLibraryOrSdkSettings(orderEntry);
                }
            } else {
                service.openContentEntriesSettings(module2);
            }
        }
    }

    public String getNavigateActionText(boolean focusEditor) {
        VirtualFile file2 = this.getVirtualFile();
        Project project2 = this.getProject();
        if (file2 != null && project2 != null) {
            if (ProjectRootsUtil.isModuleContentRoot(file2, project2) || ProjectRootsUtil.isModuleSourceRoot(file2, project2)) {
                return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
            }
            if (ProjectRootsUtil.isLibraryRoot(file2, project2)) {
                return ActionsBundle.message((String)"action.LibrarySettings.navigate", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public int getWeight() {
        ProjectView projectView = ProjectView.getInstance(this.myProject);
        if (projectView instanceof ProjectViewImpl && !((ProjectViewImpl)projectView).isFoldersAlwaysOnTop()) {
            return 20;
        }
        return this.isFQNameShown() ? 70 : 0;
    }

    public String getTitle() {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory != null) {
            return PsiDirectoryFactory.getInstance(this.getProject()).getQualifiedName(directory, true);
        }
        return super.getTitle();
    }

    public Comparable getSortKey() {
        if (ProjectAttachProcessor.canAttachToProject()) {
            VirtualFile file2 = this.getVirtualFile();
            if (Comparing.equal((Object)file2, (Object)this.myProject.getBaseDir())) {
                return "";
            }
            return this.getTitle();
        }
        return null;
    }

    public Comparable getTypeSortKey() {
        String extension;
        VirtualFile file2 = this.getVirtualFile();
        if (file2 != null && (extension = file2.getExtension()) != null) {
            return new PsiFileNode.ExtensionSortKey(extension);
        }
        return null;
    }

    public String getQualifiedNameSortKey() {
        PsiDirectoryFactory factory = PsiDirectoryFactory.getInstance(this.getProject());
        return factory.getQualifiedName((PsiDirectory)this.getValue(), true);
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 3;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 == null || file2.getChildren().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PsiDirectoryNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "moduleNameMatchesDirectoryName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

