/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<String, Icon>> myPresentations;
    private T mySelection;
    private Consumer<T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myItemsIterable;
    private JBIterable<T> myExtraItems;

    @NotNull
    public static ListPopup forFileLanguages(final @NotNull Project project2, @NotNull Iterable<VirtualFile> files, @NotNull PerFileMappings<Language> mappings) {
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(0);
        }
        if (files == null) {
            LRUPopupBuilder.$$$reportNull$$$0(1);
        }
        if (mappings == null) {
            LRUPopupBuilder.$$$reportNull$$$0(2);
        }
        VirtualFile[] filesCopy = VfsUtilCore.toVirtualFileArray((Collection)JBIterable.from(files).toList());
        Arrays.sort(filesCopy, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (!o1.getFileSystem().isCaseSensitive() ? 1 : 0) != 0));
        ListPopup listPopup = LRUPopupBuilder.forFileLanguages(project2, null, (Consumer<Language>)((Consumer)t -> {
            if (project2 == null) {
                LRUPopupBuilder.$$$reportNull$$$0(25);
            }
            if (mappings == null) {
                LRUPopupBuilder.$$$reportNull$$$0(26);
            }
            new WriteCommandAction(project2, "Change Language", new PsiFile[0], (Language)t, filesCopy, (PerFileMappings)mappings){
                final /* synthetic */ Language val$t;
                final /* synthetic */ VirtualFile[] val$filesCopy;
                final /* synthetic */ PerFileMappings val$mappings;
                {
                    this.val$t = language;
                    this.val$filesCopy = virtualFileArray;
                    this.val$mappings = perFileMappings;
                    super(arg0, arg1, arg2);
                }

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LRUPopupBuilder.changeLanguageWithUndo(project2, this.val$t, this.val$filesCopy, (PerFileMappings<Language>)this.val$mappings);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/scratch/LRUPopupBuilder$1", "run"));
                }
            }.execute();
        }));
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project2, @Nullable Language selection, @NotNull Consumer<Language> onChosen) {
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(4);
        }
        if (onChosen == null) {
            LRUPopupBuilder.$$$reportNull$$$0(5);
        }
        ListPopup listPopup = LRUPopupBuilder.languagePopupBuilder(project2, "Languages").forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen).buildPopup();
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(6);
        }
        return listPopup;
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project2, @NotNull String title) {
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(7);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(8);
        }
        LRUPopupBuilder<Language> lRUPopupBuilder = new LRUPopupBuilder<Language>(project2, title){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(9);
        }
        return lRUPopupBuilder;
    }

    protected LRUPopupBuilder(@NotNull Project project2, @NotNull String title) {
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(10);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(11);
        }
        this.myPresentations = ContainerUtil.newIdentityHashMap();
        this.myExtraItems = JBIterable.empty();
        this.myTitle = title;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project2);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myItemsIterable = items;
        return this;
    }

    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        return this;
    }

    public LRUPopupBuilder<T> withExtra(@NotNull T extra, @NotNull String displayName, @Nullable Icon icon) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(12);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(13);
        }
        this.myExtraItems = this.myExtraItems.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon));
        return this;
    }

    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<T> consumer) {
        this.myOnChosen = consumer;
        return this;
    }

    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        return this;
    }

    @NotNull
    public ListPopup buildPopup() {
        ArrayList ids = ContainerUtil.newArrayList((Object[])this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        ArrayList lru = ContainerUtil.newArrayListWithCapacity((int)4);
        ArrayList items = ContainerUtil.newArrayListWithCapacity((int)20);
        final List extra = this.myExtraItems.toList();
        for (T t : this.myItemsIterable) {
            (ContainerUtil.indexOf((List)ids, (Object)this.getStorageId(t)) != -1 ? lru : items).add(t);
        }
        if (this.myComparator != null) {
            Collections.sort(items, this.myComparator);
        }
        if (!lru.isEmpty()) {
            Collections.sort(lru, (o1, o2) -> ContainerUtil.indexOf((List)ids, (Object)this.getStorageId(o1)) - ContainerUtil.indexOf((List)ids, (Object)this.getStorageId(o2)));
        }
        final Object separator1 = !lru.isEmpty() && !items.isEmpty() ? items.get(0) : null;
        final Object separator2 = !lru.isEmpty() || !items.isEmpty() ? ContainerUtil.getFirstItem((List)extra) : null;
        List combinedItems = ContainerUtil.concat((List[])new List[]{lru, items, extra});
        BaseListPopupStep step = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(T t) {
                String string = t == null ? "" : (String)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).first;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(T t) {
                return t == null ? null : (Icon)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(T t, boolean finalChoice) {
                if (!extra.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    this.doFinalStep(() -> LRUPopupBuilder.this.myOnChosen.consume(t));
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value2) {
                return value2 == separator1 || value2 == separator2 ? new ListSeparator() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder$3", "getTextFor"));
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step.setDefaultOptionIndex(selection);
        ListPopup listPopup = LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(14);
        }
        return listPopup;
    }

    @NotNull
    private Pair<String, Icon> getPresentation(T t) {
        Pair p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create((Object)this.getDisplayName(t), (Object)this.getIcon(t));
            this.myPresentations.put(t, (Pair<String, Icon>)p);
        }
        Pair pair2 = p;
        if (pair2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(15);
        }
        return pair2;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup2) {
        if (popup2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(16);
        }
        int nameLen = 0;
        ListPopupStep step = popup2.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup2.setSize(size);
        }
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(17);
        }
        return listPopup;
    }

    @NotNull
    private String[] restoreLRUItems() {
        String[] stringArray = (String[])ObjectUtils.notNull((Object)this.myPropertiesComponent.getValues(this.getLRUKey()), (Object)ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            LRUPopupBuilder.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    private void storeLRUItems(@NotNull T t) {
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(19);
        }
        String[] values = this.myPropertiesComponent.getValues(this.getLRUKey());
        ArrayList lastUsed = ContainerUtil.newArrayListWithCapacity((int)4);
        lastUsed.add(this.getStorageId(t));
        if (values != null) {
            for (String value2 : values) {
                if (!lastUsed.contains(value2)) {
                    lastUsed.add(value2);
                }
                if (lastUsed.size() == 4) break;
            }
        }
        this.myPropertiesComponent.setValues(this.getLRUKey(), ArrayUtil.toStringArray((Collection)lastUsed));
    }

    @NotNull
    private String getLRUKey() {
        String string = this.getClass().getName() + "/" + this.myTitle;
        if (string == null) {
            LRUPopupBuilder.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static void changeLanguageWithUndo(@NotNull Project project2, final @NotNull Language t, final @NotNull VirtualFile[] sortedFiles, final @NotNull PerFileMappings<Language> mappings) throws UnexpectedUndoException {
        ReadonlyStatusHandler.OperationStatus status;
        if (project2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(21);
        }
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(22);
        }
        if (sortedFiles == null) {
            LRUPopupBuilder.$$$reportNull$$$0(23);
        }
        if (mappings == null) {
            LRUPopupBuilder.$$$reportNull$$$0(24);
        }
        if ((status = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(sortedFiles)).hasReadonlyFiles()) {
            return;
        }
        LinkedHashSet matchedExtensions = ContainerUtil.newLinkedHashSet();
        final HashMap oldMapping = ContainerUtil.newHashMap();
        for (VirtualFile file2 : sortedFiles) {
            oldMapping.put(file2, mappings.getMapping(file2));
            if (!ScratchUtil.hasMatchingExtension(project2, file2)) continue;
            matchedExtensions.add(file2);
        }
        BasicUndoableAction action = new BasicUndoableAction(sortedFiles){

            public void undo() throws UnexpectedUndoException {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, oldMapping.get(file2));
                }
            }

            public void redo() throws UnexpectedUndoException {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, (Object)t);
                }
            }
        };
        action.redo();
        UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)action);
        for (VirtualFile file3 : matchedExtensions) {
            try {
                ScratchUtil.updateFileExtension(project2, file3);
            }
            catch (IOException iOException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forFileLanguages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "languagePopupBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPopup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakSizeToPreferred";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreLRUItems";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFileLanguages";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "languagePopupBuilder";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withExtra";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tweakSizeToPreferred";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "storeLRUItems";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguageWithUndo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forFileLanguages$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

