/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchUtil {
    private ScratchUtil() {
    }

    public static boolean isScratch(@Nullable VirtualFile file2) {
        return file2 != null && file2.getFileType() == ScratchFileType.INSTANCE;
    }

    public static void updateFileExtension(@NotNull Project project2, @Nullable VirtualFile file2) throws IOException {
        LanguageFileType actual;
        if (project2 == null) {
            ScratchUtil.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            throw new AssertionError((Object)"command required");
        }
        if (file2 == null) {
            return;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
        FileType expected = ScratchUtil.getFileTypeFromName(file2);
        LanguageFileType languageFileType = actual = language == null ? null : language.getAssociatedFileType();
        if (expected == actual || actual == null) {
            return;
        }
        String ext = actual.getDefaultExtension();
        if (StringUtil.isEmpty((String)ext)) {
            return;
        }
        String newName = PathUtil.makeFileName((String)file2.getNameWithoutExtension(), (String)ext);
        VirtualFile parent = file2.getParent();
        newName = parent != null && parent.findChild(newName) != null ? PathUtil.makeFileName((String)file2.getName(), (String)ext) : newName;
        file2.rename(ScratchUtil.class, newName);
    }

    public static boolean hasMatchingExtension(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ScratchUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ScratchUtil.$$$reportNull$$$0(2);
        }
        FileType expected = ScratchUtil.getFileTypeFromName(file2);
        Language language = LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
        LanguageFileType actual = language == null ? null : language.getAssociatedFileType();
        return expected == actual && actual != null;
    }

    @Nullable
    private static FileType getFileTypeFromName(@NotNull VirtualFile file2) {
        String extension;
        if (file2 == null) {
            ScratchUtil.$$$reportNull$$$0(3);
        }
        return (extension = file2.getExtension()) == null ? null : FileTypeManager.getInstance().getFileTypeByExtension(extension);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/scratch/ScratchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFileExtension";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMatchingExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileTypeFromName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

