/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.util.Collection;

public abstract class ChangeListTodosPanel
extends TodoPanel {
    private final Alarm myAlarm;

    public ChangeListTodosPanel(Project project2, TodoPanelSettings settings, Content content) {
        super(project2, settings, false, content);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        final MyChangeListManagerListener myChangeListManagerListener = new MyChangeListManagerListener();
        changeListManager.addChangeListListener((ChangeListListener)myChangeListManagerListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                ChangeListManager.getInstance((Project)ChangeListTodosPanel.this.myProject).removeChangeListListener((ChangeListListener)myChangeListManagerListener);
            }
        });
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    private final class MyChangeListManagerListener
    extends ChangeListAdapter {
        private MyChangeListManagerListener() {
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
            AppUIUtil.invokeOnEdt(() -> ChangeListTodosPanel.this.setDisplayName(IdeBundle.message((String)"changelist.todo.title", (Object[])new Object[]{newDefaultList.getName()})));
        }

        public void changeListRenamed(ChangeList list2, String oldName) {
            AppUIUtil.invokeOnEdt(() -> ChangeListTodosPanel.this.setDisplayName(IdeBundle.message((String)"changelist.todo.title", (Object[])new Object[]{list2.getName()})));
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
        }
    }
}

