/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class DarculaUIUtil {
    private static final Color GLOW_COLOR = new JBColor(new Color(31, 121, 212), new Color(96, 175, 255));
    private static final Color MAC_ACTIVE_ERROR_COLOR = new Color(-2131412165, true);
    private static final Color DEFAULT_ACTIVE_ERROR_COLOR = new JBColor(15023693, 9124924);
    private static final Color MAC_INACTIVE_ERROR_COLOR = new Color(-2131247940, true);
    private static final Color DEFAULT_INACTIVE_ERROR_COLOR = new JBColor(0xEBBCBC, 0x725252);
    public static final Color ACTIVE_ERROR_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_ACTIVE_ERROR_COLOR : DEFAULT_ACTIVE_ERROR_COLOR);
    public static final Color INACTIVE_ERROR_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_INACTIVE_ERROR_COLOR : DEFAULT_INACTIVE_ERROR_COLOR);
    private static final Color MAC_ACTIVE_WARNING_COLOR = new Color(-2132169405, true);
    private static final Color DEFAULT_ACTIVE_WARNING_COLOR = new JBColor(14853434, 11303200);
    private static final Color MAC_INACTIVE_WARNING_COLOR = new Color(-2130716007, true);
    private static final Color DEFAULT_INACTIVE_WARNING_COLOR = new JBColor(16765829, 7230244);
    public static final Color ACTIVE_WARNING_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_ACTIVE_WARNING_COLOR : DEFAULT_ACTIVE_WARNING_COLOR);
    public static final Color INACTIVE_WARNING_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_INACTIVE_WARNING_COLOR : DEFAULT_INACTIVE_WARNING_COLOR);
    private static final Color MAC_REGULAR_COLOR = new Color(-2142790404, true);
    private static final Color MAC_GRAPHITE_COLOR = new Color(-2137417827, true);

    public static void paintFocusRing(Graphics g, Rectangle bounds) {
        MacUIUtil.paintFocusRing((Graphics2D)((Graphics2D)g), (Color)GLOW_COLOR, (Rectangle)bounds);
    }

    public static void paintFocusOval(Graphics g, int x, int y, int width, int height) {
        MacUIUtil.paintFocusRing((Graphics2D)((Graphics2D)g), (Color)GLOW_COLOR, (Rectangle)new Rectangle(x, y, width, height), (boolean)true);
    }

    public static void paintSearchFocusRing(Graphics2D g, Rectangle bounds, Component component) {
        DarculaUIUtil.paintSearchFocusRing(g, bounds, component, -1);
    }

    public static void paintSearchFocusRing(Graphics2D g, Rectangle bounds, Component component, int maxArcSize) {
        int correction = UIUtil.isUnderAquaLookAndFeel() ? 30 : (UIUtil.isUnderDarcula() ? 50 : 0);
        Color[] colors = new Color[]{ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(180 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(120 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(70 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(100 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(50 - correction))};
        Object oldAntialiasingValue = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle r = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        int arcSize = r.height - 1;
        if (maxArcSize > 0) {
            arcSize = Math.min(maxArcSize, arcSize);
        }
        if (arcSize % 2 == 1) {
            --arcSize;
        }
        g.setColor(component.getBackground());
        g.fillRoundRect(r.x + 2, r.y + 2, r.width - 5, r.height - 5, arcSize - 4, arcSize - 4);
        g.setColor(colors[0]);
        g.drawRoundRect(r.x + 2, r.y + 2, r.width - 5, r.height - 5, arcSize - 4, arcSize - 4);
        g.setColor(colors[1]);
        g.drawRoundRect(r.x + 1, r.y + 1, r.width - 3, r.height - 3, arcSize - 2, arcSize - 2);
        g.setColor(colors[2]);
        g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, arcSize, arcSize);
        g.setColor(colors[3]);
        g.drawRoundRect(r.x + 3, r.y + 3, r.width - 7, r.height - 7, arcSize - 6, arcSize - 6);
        g.setColor(colors[4]);
        g.drawRoundRect(r.x + 4, r.y + 4, r.width - 9, r.height - 9, arcSize - 8, arcSize - 8);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    @Deprecated
    public static void paintErrorBorder(Graphics2D g, int width, int height, int arc, boolean symmetric, boolean hasFocus) {
        DarculaUIUtil.paintOutlineBorder(g, width, height, arc, symmetric, hasFocus, Outline.error);
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, boolean symmetric, boolean hasFocus, Outline type2) {
        type2.setGraphicsColor(g, hasFocus);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, int arc, boolean symmetric) {
        DarculaUIUtil.paintFocusBorder(g, width, height, (float)arc, symmetric);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, boolean symmetric) {
        g.setPaint(IntelliJLaf.isGraphite() ? MAC_GRAPHITE_COLOR : MAC_REGULAR_COLOR);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    private static void doPaint(Graphics2D g, int width, int height, float arc, boolean symmetric) {
        double bw = UIUtil.isUnderDefaultMacTheme() ? (double)JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g) ? 0.5f : 1.0f)) : 0.0;
        double lw = JBUI.scale((int)(UIUtil.isUnderDefaultMacTheme() ? 3 : 2));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        double outerArc = arc > 0.0f ? (double)arc + lw - (double)JBUI.scale((float)2.0f) : lw;
        double rightOuterArc = symmetric ? outerArc : (double)JBUI.scale((float)6.0f);
        Path2D.Double outerRect = new Path2D.Double(0);
        ((Path2D)outerRect).moveTo((double)width - rightOuterArc, 0.0);
        ((Path2D)outerRect).quadTo(width, 0.0, width, rightOuterArc);
        ((Path2D)outerRect).lineTo(width, (double)height - rightOuterArc);
        ((Path2D)outerRect).quadTo(width, height, (double)width - rightOuterArc, height);
        ((Path2D)outerRect).lineTo(outerArc, height);
        ((Path2D)outerRect).quadTo(0.0, height, 0.0, (double)height - outerArc);
        ((Path2D)outerRect).lineTo(0.0, outerArc);
        ((Path2D)outerRect).quadTo(0.0, 0.0, outerArc, 0.0);
        outerRect.closePath();
        double rightInnerArc = symmetric ? outerArc : (double)JBUI.scale((float)7.0f);
        Path2D.Double innerRect = new Path2D.Double(0);
        ((Path2D)innerRect).moveTo((double)width - rightInnerArc, lw += bw);
        ((Path2D)innerRect).quadTo((double)width - lw, lw, (double)width - lw, rightInnerArc);
        ((Path2D)innerRect).lineTo((double)width - lw, (double)height - rightInnerArc);
        ((Path2D)innerRect).quadTo((double)width - lw, (double)height - lw, (double)width - rightInnerArc, (double)height - lw);
        ((Path2D)innerRect).lineTo(outerArc, (double)height - lw);
        ((Path2D)innerRect).quadTo(lw, (double)height - lw, lw, (double)height - outerArc);
        ((Path2D)innerRect).lineTo(lw, outerArc);
        ((Path2D)innerRect).quadTo(lw, lw, outerArc, lw);
        innerRect.closePath();
        Path2D.Double path = new Path2D.Double(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
    }

    public static boolean isCurrentEventShiftDownEvent() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        return event instanceof KeyEvent && ((KeyEvent)event).isShiftDown();
    }

    public static int getPatchedNextVisualPositionFrom(JTextComponent t, int pos, int direction) {
        if (!DarculaUIUtil.isCurrentEventShiftDownEvent()) {
            if (direction == 7 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionEnd() == pos) {
                return t.getSelectionStart();
            }
            if (direction == 3 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionStart() == pos) {
                return t.getSelectionEnd();
            }
        }
        return -1;
    }

    public static class MouseHoverPropertyTrigger
    extends MouseAdapter {
        private final JComponent repaintComponent;
        private final String hoverProperty;

        public MouseHoverPropertyTrigger(@NotNull JComponent repaintComponent, @NotNull String hoverProperty) {
            if (repaintComponent == null) {
                MouseHoverPropertyTrigger.$$$reportNull$$$0(0);
            }
            if (hoverProperty == null) {
                MouseHoverPropertyTrigger.$$$reportNull$$$0(1);
            }
            this.repaintComponent = repaintComponent;
            this.hoverProperty = hoverProperty;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setHover((JComponent)e.getComponent(), Boolean.TRUE);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setHover((JComponent)e.getComponent(), Boolean.FALSE);
        }

        private void setHover(JComponent c, Boolean value2) {
            if (c.isEnabled()) {
                c.putClientProperty(this.hoverProperty, value2);
                this.repaintComponent.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repaintComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hoverProperty";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/ui/laf/darcula/DarculaUIUtil$MouseHoverPropertyTrigger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class WinEditorTextFieldBorder
    extends DarculaEditorTextFieldBorder {
        public WinEditorTextFieldBorder(final EditorTextField editorTextField, EditorEx editor) {
            super(editorTextField, editor);
            editor.addEditorMouseListener((EditorMouseListener)new EditorMouseAdapter(){

                public void mouseEntered(EditorMouseEvent e) {
                    editorTextField.putClientProperty("JTextField.hover", Boolean.TRUE);
                    editorTextField.repaint();
                }

                public void mouseExited(EditorMouseEvent e) {
                    editorTextField.putClientProperty("JTextField.hover", Boolean.FALSE);
                    editorTextField.repaint();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (WinEditorTextFieldBorder.isComboBoxEditor(c)) {
                g.setColor(c.getBackground());
                g.fillRect(x, y, width, height);
                return;
            }
            EditorTextField editorTextField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Rectangle r = new Rectangle(x, y, width, height);
                if (UIUtil.getParentOfType(Wrapper.class, (Component)c) != null && TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c)) {
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2, (int)0));
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                if (this.isBorderOpaque() || c.getParent() != null) {
                    g2.setColor(c.getParent().getBackground());
                    Path2D.Double borderArea = new Path2D.Double(0);
                    borderArea.append(r, false);
                    Rectangle innerRect = new Rectangle(r);
                    JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)2));
                    borderArea.append(innerRect, false);
                    g2.fill(borderArea);
                }
                boolean hasFocus = editorTextField.getFocusTarget().hasFocus();
                int bw = 1;
                Object op = editorTextField.getClientProperty("JComponent.outline");
                if (op != null) {
                    Outline.valueOf(op.toString()).setGraphicsColor(g2, c.hasFocus());
                    bw = 2;
                } else {
                    if (hasFocus) {
                        g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
                    } else if (editorTextField.isEnabled() && editorTextField.getClientProperty("JTextField.hover") == Boolean.TRUE) {
                        g2.setColor(UIManager.getColor("TextField.hoverBorderColor"));
                    } else {
                        g2.setColor(UIManager.getColor("TextField.borderColor"));
                    }
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
                }
                if (!editorTextField.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                }
                Path2D.Double border = new Path2D.Double(0);
                border.append(r, false);
                Rectangle innerRect = new Rectangle(r);
                JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)bw));
                border.append(innerRect, false);
                g2.fill(border);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (UIUtil.getParentOfType(ComboBoxCompositeEditor.class, (Component)c) != null) {
                return JBUI.emptyInsets().asUIResource();
            }
            return WinEditorTextFieldBorder.isComboBoxEditor(c) ? JBUI.insets((int)1, (int)6).asUIResource() : JBUI.insets((int)4, (int)6).asUIResource();
        }
    }

    public static class MacEditorTextFieldBorder
    extends DarculaEditorTextFieldBorder {
        public MacEditorTextFieldBorder(EditorTextField editorTextField, EditorEx editor) {
            super(editorTextField, editor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (MacEditorTextFieldBorder.isComboBoxEditor(c)) {
                g.setColor(c.getBackground());
                g.fillRect(x, y, width, height);
                return;
            }
            EditorTextField editorTextField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                if (c.isOpaque() || c instanceof JComponent && ((JComponent)c).getClientProperty("MAC_FILL_BORDER") == Boolean.TRUE) {
                    g2.setColor(UIUtil.getPanelBackground());
                    g2.fillRect(x, y, width, height);
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(x + JBUI.scale((int)3), y + JBUI.scale((int)3), width - JBUI.scale((int)3) * 2, height - JBUI.scale((int)3) * 2);
                g2.setColor(c.getBackground());
                g2.fill(rect);
                if (!editorTextField.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                }
                double bw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
                Path2D.Double outline = new Path2D.Double(0);
                outline.append(rect, false);
                outline.append(new Rectangle2D.Double(((RectangularShape)rect).getX() + bw, ((RectangularShape)rect).getY() + bw, ((RectangularShape)rect).getWidth() - 2.0 * bw, ((RectangularShape)rect).getHeight() - 2.0 * bw), false);
                g2.setColor((Color)Gray.xBC);
                g2.fill(outline);
                g2.translate(x, y);
                boolean hasFocus = editorTextField.getFocusTarget().hasFocus();
                Object op = editorTextField.getClientProperty("JComponent.outline");
                if (op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, width, height, 0.0f, true, hasFocus, Outline.valueOf(op.toString()));
                } else if (editorTextField.isEnabled() && editorTextField.isVisible() && hasFocus) {
                    DarculaUIUtil.paintFocusBorder(g2, width, height, 0, true);
                }
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return MacEditorTextFieldBorder.isComboBoxEditor(c) ? new InsetsUIResource(1, 3, 2, 3) : new InsetsUIResource(6, 7, 6, 7);
        }
    }

    public static enum Outline {
        error{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(focused ? ACTIVE_ERROR_COLOR : INACTIVE_ERROR_COLOR);
            }
        }
        ,
        warning{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(focused ? ACTIVE_WARNING_COLOR : INACTIVE_WARNING_COLOR);
            }
        };


        public abstract void setGraphicsColor(Graphics2D var1, boolean var2);
    }
}

