/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import sun.swing.SwingUtilities2;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    protected volatile int offset = 0;
    private final IndeterminateProgressCache indeterminateProgressCache = new IndeterminateProgressCache();

    public static ComponentUI createUI(JComponent c) {
        c.setBorder((Border)JBUI.Borders.empty().asUIResource());
        return new DarculaProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        UIManager.put("ProgressBar.repaintInterval", new Integer(25));
        UIManager.put("ProgressBar.cycleTime", new Integer(300));
    }

    @Override
    protected void paintIndeterminate(Graphics g2d, JComponent c) {
        if (!(g2d instanceof Graphics2D)) {
            return;
        }
        Graphics2D g = (Graphics2D)g2d;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int w = c.getWidth();
        int h = c.getPreferredSize().height;
        if (!DarculaProgressBarUI.isEven(c.getHeight() - h)) {
            ++h;
        }
        if (c.isOpaque()) {
            g.setColor((Color)new JBColor((Color)Gray._240, (Color)Gray._128));
            g.fillRect(0, (c.getHeight() - h) / 2, w, h);
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        this.indeterminateProgressCache.validateAndRender(g, c, barRectWidth, barRectHeight, w, h, this.getAnimationIndex());
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString((Graphics)g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width);
            } else {
                this.paintString((Graphics)g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height);
            }
        }
        config.restore();
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.getOrientation() != 0 || !c.getComponentOrientation().isLeftToRight()) {
            super.paintDeterminate(g, c);
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Insets b = this.progressBar.getInsets();
        int w = this.progressBar.getWidth();
        int h = this.progressBar.getPreferredSize().height;
        if (!DarculaProgressBarUI.isEven(c.getHeight() - h)) {
            ++h;
        }
        int barRectWidth = w - (b.right + b.left);
        int barRectHeight = h - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        g.setColor(c.getParent().getBackground());
        Graphics2D g2 = (Graphics2D)g;
        if (c.isOpaque()) {
            g.fillRect(0, 0, w, h);
        }
        float R = JBUI.scale((float)8.0f);
        float R2 = JBUI.scale((float)9.0f);
        float off = JBUI.scale((float)1.0f);
        g2.translate(0, (c.getHeight() - h) / 2);
        g2.setColor(this.progressBar.getForeground());
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, (float)w - off, (float)h - off, R2, R2));
        g2.setColor(c.getParent().getBackground());
        g2.fill(new RoundRectangle2D.Float(off, off, (float)w - 2.0f * off - off, (float)h - 2.0f * off - off, R, R));
        g2.setColor(this.progressBar.getForeground());
        g2.fill(new RoundRectangle2D.Float(2.0f * off, 2.0f * off, (float)amountFull - JBUI.scale((float)5.0f), (float)h - JBUI.scale((float)5.0f), JBUI.scale((float)7.0f), JBUI.scale((float)7.0f)));
        g2.translate(0, -(c.getHeight() - h) / 2);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
        config.restore();
    }

    private void paintString(Graphics g, int x, int y, int w, int h, int fillStart, int amountFull) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, w, h);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, h);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, w, h);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, w, amountFull);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g2, progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    protected int getPeriodLength() {
        return JBUI.scale((int)16);
    }

    private static boolean isEven(int value2) {
        return value2 % 2 == 0;
    }

    class IndeterminateProgressCache {
        private Area containingRoundRect = null;
        private Area insetArea = null;
        private Area outerInnerBorderRoundRectArea = null;
        private Area outlineArea = null;
        private Path2D path = null;
        private ArrayList<TexturePaint> pathPaintList = new ArrayList();
        private int barRectWidth = -1;
        private int barRectHeight = -1;
        private int w = -1;
        private int h = -1;
        private int cHeight = -1;
        private float off = 0.0f;

        IndeterminateProgressCache() {
        }

        synchronized void validateAndRender(Graphics2D g, JComponent c, int barRectWidth, int barRectHeight, int w, int h, int frame) {
            float newOff = JBUI.scale((float)1.0f);
            if (this.path == null || barRectWidth != this.barRectWidth || barRectHeight != this.barRectHeight || w != this.w || h != this.h || c.getHeight() != this.cHeight || this.off != newOff) {
                this.cHeight = c.getHeight();
                this.path = new Path2D.Double();
                for (int x = h / 2; x < 2 * DarculaProgressBarUI.this.getPeriodLength(); x += DarculaProgressBarUI.this.getPeriodLength()) {
                    float ww = (float)DarculaProgressBarUI.this.getPeriodLength() / 2.0f;
                    this.path.moveTo(x, 0.0);
                    this.path.lineTo((float)x + ww, 0.0);
                    this.path.lineTo((float)x + ww - (float)(h / 2), h);
                    this.path.lineTo(x - h / 2, h);
                    this.path.lineTo(x, 0.0);
                    this.path.closePath();
                }
                BufferedImage pathTile = UIUtil.createImage((int)DarculaProgressBarUI.this.getPeriodLength(), (int)barRectHeight, (int)2);
                Graphics2D gpt = pathTile.createGraphics();
                GraphicsUtil.setupAAPainting((Graphics)gpt);
                gpt.setColor((Color)new JBColor((Color)Gray._165, (Color)Gray._88));
                gpt.fill(this.path);
                this.pathPaintList.clear();
                for (int i = 0; i < DarculaProgressBarUI.this.getFrameCount(); ++i) {
                    double progressOffset = (double)i * (double)DarculaProgressBarUI.this.getPeriodLength() / (double)DarculaProgressBarUI.this.getFrameCount();
                    TexturePaint pathPaint = new TexturePaint(pathTile, new Rectangle2D.Double(Math.rint((double)DarculaProgressBarUI.this.getPeriodLength() - progressOffset), 0.0, DarculaProgressBarUI.this.getPeriodLength(), barRectHeight));
                    this.pathPaintList.add(pathPaint);
                }
                this.barRectWidth = barRectWidth;
                this.barRectHeight = barRectHeight;
                this.w = w;
                this.h = h;
                float R = JBUI.scale((float)8.0f);
                float R2 = JBUI.scale((float)9.0f);
                this.off = newOff;
                Area cachedInnerBorderRoundRect = new Area(new RoundRectangle2D.Float(this.off, this.off, (float)w - 2.0f * this.off, (float)h - 2.0f * this.off, R, R));
                this.containingRoundRect = new Area(new RoundRectangle2D.Float(2.0f * this.off, 2.0f * this.off, (float)w - 4.0f * this.off, (float)h - 4.0f * this.off, R, R));
                this.insetArea = new Area(cachedInnerBorderRoundRect);
                this.insetArea.subtract(this.containingRoundRect);
                this.outerInnerBorderRoundRectArea = new Area(new Rectangle2D.Float(0.0f, 0.0f, w, h));
                this.outerInnerBorderRoundRectArea.subtract(cachedInnerBorderRoundRect);
                this.outlineArea = new Area(this.outerInnerBorderRoundRectArea);
                this.outlineArea.subtract(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, R2, R2)));
            }
            g.translate(0, (c.getHeight() - h) / 2);
            g.setPaint(this.pathPaintList.get(frame));
            g.fill(this.containingRoundRect);
            g.setColor((Color)Gray._128);
            if (c.isOpaque()) {
                g.fill(this.outerInnerBorderRoundRectArea);
            }
            g.setColor(c.getParent().getBackground());
            if (c.isOpaque()) {
                g.fill(this.outlineArea);
            }
            g.fill(this.insetArea);
            g.translate(0, -(c.getHeight() - h) / 2);
        }
    }
}

