/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.FrameworkGroupNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNodeBase;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FrameworksTree
extends CheckboxTree {
    private boolean myProcessingMouseEventOnCheckbox;

    public FrameworksTree(FrameworkSupportModelBase model) {
        super(new FrameworksTreeRenderer(model), new CheckedTreeNode(), new CheckboxTreeBase.CheckPolicy(false, true, true, false));
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setRowHeight(0);
        this.putClientProperty("JTree.lineStyle", "None");
    }

    public void setRoots(List<FrameworkSupportNodeBase> roots) {
        CheckedTreeNode root = new CheckedTreeNode(null);
        for (FrameworkSupportNodeBase base : roots) {
            root.add((MutableTreeNode)((Object)base));
        }
        this.setModel(new DefaultTreeModel((TreeNode)root));
        TreeUtil.expandAll((JTree)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMouseEvent(MouseEvent e) {
        Object node;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null && (node = path.getLastPathComponent()) instanceof FrameworkSupportNode) {
            Rectangle checkboxBounds = ((CheckboxTreeBase.CheckboxTreeCellRendererBase)this.getCellRenderer()).myCheckbox.getBounds();
            Rectangle pathBounds = this.getPathBounds(path);
            assert (pathBounds != null);
            checkboxBounds.setLocation(pathBounds.getLocation());
            if (checkboxBounds.contains(e.getPoint())) {
                try {
                    this.myProcessingMouseEventOnCheckbox = true;
                    super.processMouseEvent(e);
                }
                finally {
                    this.myProcessingMouseEventOnCheckbox = false;
                }
                return;
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, (Convertor<TreePath, String>)((Convertor)path -> {
            Object node = path.getLastPathComponent();
            if (node instanceof FrameworkSupportNodeBase) {
                return ((FrameworkSupportNodeBase)((Object)((Object)node))).getTitle();
            }
            return "";
        }));
    }

    public boolean isProcessingMouseEventOnCheckbox() {
        return this.myProcessingMouseEventOnCheckbox;
    }

    public boolean selectFramework(String id, boolean checked) {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        return !TreeUtil.traverse((TreeNode)root, node -> {
            if (node instanceof FrameworkSupportNode && id.equals(((FrameworkSupportNode)((Object)((Object)node))).getId())) {
                ((FrameworkSupportNode)((Object)((Object)node))).setChecked(checked);
                return false;
            }
            return true;
        });
    }

    private static class FrameworksTreeRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final FrameworkSupportModelBase myModel;

        private FrameworksTreeRenderer(FrameworkSupportModelBase model) {
            super(true, false);
            this.myModel = model;
            Border border = JBUI.Borders.empty((int)2);
            this.setBorder(border);
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof FrameworkSupportNodeBase) {
                Object object;
                String version;
                FrameworkSupportNodeBase node = (FrameworkSupportNodeBase)((Object)value2);
                SimpleTextAttributes attributes = node instanceof FrameworkGroupNode ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                this.getTextRenderer().append(node.getTitle(), attributes);
                if (node.isChecked() && (version = this.myModel.getFrameworkVersion((object = node.getUserObject()).getId())) != null) {
                    this.getTextRenderer().append(" (" + version + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                this.getTextRenderer().setIcon(node.getIcon());
                this.getCheckbox().setVisible(value2 instanceof FrameworkSupportNode);
            }
        }
    }
}

