/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeViewUtil {
    private static final int SUBPACKAGE_LIMIT = 2;
    private static final Key<ConcurrentMap<PsiPackage, Boolean>> SHOULD_ABBREV_PACK_KEY = Key.create((String)"PACK_ABBREV_CACHE");

    private static boolean shouldAbbreviateName(PsiPackage aPackage) {
        Boolean ret;
        ConcurrentMap newMap;
        Project project2 = aPackage.getProject();
        ConcurrentMap map = (ConcurrentMap)project2.getUserData(SHOULD_ABBREV_PACK_KEY);
        if (map == null && (map = (ConcurrentMap)((UserDataHolderEx)project2).putUserDataIfAbsent(SHOULD_ABBREV_PACK_KEY, (Object)(newMap = ContainerUtil.createConcurrentWeakMap()))) == newMap) {
            PsiManagerEx.getInstanceEx(project2).registerRunnableToRunOnChange(() -> newMap.clear());
        }
        if ((ret = (Boolean)map.get(aPackage)) != null) {
            return ret;
        }
        ret = TreeViewUtil.scanPackages(aPackage, 1);
        map.put(aPackage, ret);
        return ret;
    }

    private static boolean scanPackages(@NotNull PsiPackage p, int packageNameOccurrencesFound) {
        PsiPackage[] subPackages;
        if (p == null) {
            TreeViewUtil.$$$reportNull$$$0(0);
        }
        if ((packageNameOccurrencesFound += (subPackages = p.getSubPackages()).length) > 2) {
            return true;
        }
        for (PsiPackage subPackage : subPackages) {
            if (!TreeViewUtil.scanPackages(subPackage, packageNameOccurrencesFound)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String calcAbbreviatedPackageFQName(@NotNull PsiPackage aPackage) {
        String packageName;
        if (aPackage == null) {
            TreeViewUtil.$$$reportNull$$$0(1);
        }
        StringBuilder name2 = new StringBuilder(aPackage.getName());
        for (PsiPackage parentPackage = aPackage.getParentPackage(); parentPackage != null && (packageName = parentPackage.getName()) != null && !packageName.isEmpty(); parentPackage = parentPackage.getParentPackage()) {
            name2.insert(0, ".");
            if (packageName.length() > 2 && TreeViewUtil.shouldAbbreviateName(parentPackage)) {
                name2.insert(0, packageName.substring(0, 1));
                continue;
            }
            name2.insert(0, packageName);
        }
        String string = name2.toString();
        if (string == null) {
            TreeViewUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isEmptyMiddlePackage(@NotNull PsiDirectory dir, boolean strictlyEmpty, @Nullable PsiFileSystemItemFilter filter2) {
        VirtualFile[] files;
        if (dir == null) {
            TreeViewUtil.$$$reportNull$$$0(3);
        }
        if ((files = dir.getVirtualFile().getChildren()).length == 0) {
            return false;
        }
        PsiManager manager = dir.getManager();
        int subpackagesCount = 0;
        int directoriesCount = 0;
        for (VirtualFile file2 : files) {
            PsiDirectory childDir;
            if (FileTypeManager.getInstance().isFileIgnored(file2)) continue;
            if (!file2.isDirectory()) {
                if (filter2 == null) {
                    return false;
                }
                PsiFile childFile = manager.findFile(file2);
                if (childFile != null && filter2.shouldShow((PsiFileSystemItem)childFile)) {
                    return false;
                }
            }
            if ((childDir = manager.findDirectory(file2)) == null || filter2 != null && !filter2.shouldShow((PsiFileSystemItem)childDir)) continue;
            if (strictlyEmpty && ++directoriesCount > 1) {
                return false;
            }
            if (JavaDirectoryService.getInstance().getPackage(childDir) == null) continue;
            ++subpackagesCount;
        }
        if (strictlyEmpty) {
            return directoriesCount == subpackagesCount && directoriesCount == 1;
        }
        return directoriesCount == subpackagesCount && directoriesCount > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/TreeViewUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/TreeViewUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAbbreviatedPackageFQName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scanPackages";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcAbbreviatedPackageFQName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyMiddlePackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

