/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class HidpiInfo
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent anActionEvent) {
        String mode = UIUtil.isJreHiDPIEnabled() ? "enabled" : "disabled";
        ArrayList<Pair> values = new ArrayList<Pair>();
        values.add(Pair.create((Object)"JRE HiDPI", (Object)mode));
        values.add(Pair.create((Object)"User scale", (Object)("" + JBUI.scale((float)1.0f))));
        values.add(Pair.create((Object)"System scale", (Object)("" + JBUI.sysScale((Component)IdeFrameImpl.getActiveFrame()))));
        final int KEY_MIN_WIDTH = GraphicsUtil.stringWidth((String)"System scale", (Font)UIUtil.getLabelFont()) + JBUI.scale((int)8);
        final int VAL_MIN_WIDTH = GraphicsUtil.stringWidth((String)mode, (Font)UIUtil.getLabelFont()) + JBUI.scale((int)8);
        ListPopupImpl popup2 = new ListPopupImpl((ListPopupStep)new BaseListPopupStep("HiDPI Info", values)){

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new ListCellRenderer(){
                    Border myBorder = BorderFactory.createCompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1), JBUI.Borders.empty((int)2));

                    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                        Pair pair2 = (Pair)value2;
                        JPanel panel2 = new JPanel();
                        panel2.setLayout(new FlowLayout());
                        panel2.add(this.label((String)pair2.first, KEY_MIN_WIDTH));
                        panel2.add(this.label((String)pair2.second, VAL_MIN_WIDTH));
                        return panel2;
                    }

                    JLabel label(String value2, int width) {
                        JLabel label = new JLabel(value2);
                        label.setPreferredSize(new Dimension(width, label.getPreferredSize().height));
                        label.setBorder(this.myBorder);
                        return label;
                    }
                };
            }
        };
        popup2.getList().setBackground(UIManager.getColor("Panel.background"));
        popup2.getList().setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public boolean isSelectedIndex(int i) {
                return false;
            }

            @Override
            public boolean isSelectionEmpty() {
                return true;
            }
        });
        popup2.showInCenterOf(IdeFrameImpl.getActiveFrame());
    }
}

