/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.stubtree;

import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.internal.psiView.PsiViewerDialog;
import com.intellij.internal.psiView.ViewerPsiBasedTree;
import com.intellij.internal.psiView.stubtree.PsiViewerStubTreeBuilder;
import com.intellij.internal.psiView.stubtree.StubTreeNode;
import com.intellij.internal.psiView.stubtree.StubTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubViewerPsiBasedTree
implements ViewerPsiBasedTree {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.psiView.PsiViewerDialog");
    private static final Key<Object> PSI_ELEMENT_SELECTION_REQUESTOR = Key.create((String)"SelectionRequester");
    @Nullable
    private PsiViewerStubTreeBuilder myStubTreeBuilder;
    @NotNull
    private final Tree myStubTree;
    @Nullable
    private JPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewerPsiBasedTree.PsiTreeUpdater myUpdater;
    @NotNull
    private volatile Map<ASTNode, StubElement> myNodeToStubs;

    public StubViewerPsiBasedTree(@NotNull Project project2, @NotNull ViewerPsiBasedTree.PsiTreeUpdater updater) {
        if (project2 == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(0);
        }
        if (updater == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(1);
        }
        this.myNodeToStubs = new BidirectionalMap();
        this.myProject = project2;
        this.myUpdater = updater;
        this.myStubTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    @Override
    public void reloadTree(@Nullable PsiElement rootRootElement, @NotNull String text2) {
        if (text2 == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(2);
        }
        this.resetStubTree();
        this.buildStubTree(rootRootElement, text2);
    }

    private void resetStubTree() {
        this.myStubTree.removeAll();
        if (this.myStubTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myStubTreeBuilder);
            this.myStubTreeBuilder = null;
        }
        this.myNodeToStubs = new BidirectionalMap();
        ViewerPsiBasedTree.removeListenerOfClass(this.myStubTree, StubTreeSelectionListener.class);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        if (this.myPanel != null) {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                StubViewerPsiBasedTree.$$$reportNull$$$0(3);
            }
            return jPanel;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add(ScrollPaneFactory.createScrollPane((Component)this.myStubTree));
        panel2.setBorder(IdeBorderFactory.createBorder());
        PsiViewerDialog.initTree((JTree)this.myStubTree);
        this.myPanel = panel2;
        JPanel jPanel = panel2;
        if (jPanel == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    public boolean isFocusOwner() {
        return this.myStubTree.isFocusOwner();
    }

    @Override
    public void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myStubTree, true);
    }

    private synchronized void buildStubTree(@Nullable PsiElement rootElement, @NotNull String textToParse) {
        if (textToParse == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(5);
        }
        if (rootElement == null) {
            this.myStubTree.setRootVisible(false);
            return;
        }
        if (!(rootElement instanceof PsiFileWithStubSupport)) {
            this.myStubTree.setRootVisible(false);
            StatusText text2 = this.myStubTree.getEmptyText();
            if (rootElement instanceof PsiFile) {
                text2.setText("No stubs for " + rootElement.getLanguage().getDisplayName());
            } else {
                text2.setText("Cannot build stub tree for code fragments");
            }
            return;
        }
        Stub stub = StubViewerPsiBasedTree.buildStubForElement(this.myProject, rootElement, textToParse);
        if (stub instanceof PsiFileStub) {
            PsiFileWithStubSupport file2 = (PsiFileWithStubSupport)rootElement;
            StubTreeNode rootNode = new StubTreeNode((StubElement)stub, null);
            StubTreeStructure treeStructure = new StubTreeStructure(rootNode);
            this.myStubTreeBuilder = new PsiViewerStubTreeBuilder((JTree)this.myStubTree, treeStructure);
            this.fillPsiToStubCache(file2, (PsiFileStub)stub);
            this.myStubTree.setRootVisible(true);
            this.myStubTree.expandRow(0);
            this.myStubTree.addTreeSelectionListener((TreeSelectionListener)new StubTreeSelectionListener(file2));
            this.myStubTreeBuilder.queueUpdate();
        } else {
            this.myStubTree.setRootVisible(false);
            StatusText text3 = this.myStubTree.getEmptyText();
            text3.setText("Cannot build stubs for " + rootElement.getLanguage().getDisplayName());
        }
    }

    public void dispose() {
        this.resetStubTree();
    }

    @Nullable
    private static Stub buildStubForElement(Project project2, PsiElement rootElement, @NotNull String textToParse) {
        if (textToParse == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(6);
        }
        PsiFileStub stub = null;
        StubTree tree = ((PsiFileWithStubSupport)rootElement).getStubTree();
        if (tree != null) {
            stub = tree.getRoot();
        } else if (rootElement instanceof PsiFileImpl) {
            StubBuilder stubBuilder = StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)rootElement);
            StubElement stubElement = stub = stubBuilder == null ? null : stubBuilder.buildStubTree((PsiFile)rootElement);
        }
        if (stub == null) {
            LightVirtualFile file2 = new LightVirtualFile("stub", rootElement.getLanguage(), (CharSequence)textToParse);
            try {
                FileContentImpl fc = new FileContentImpl((VirtualFile)file2, file2.contentsToByteArray());
                fc.putUserData(IndexingDataKeys.PROJECT, project2);
                stub = StubTreeBuilder.buildStubTree(fc);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return stub;
    }

    @Nullable
    private static StubBuilder getStubBuilder(@NotNull PsiFileImpl rootElement) {
        IStubFileElementType builder;
        if (rootElement == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(7);
        }
        return (builder = rootElement.getElementTypeForStubBuilder()) == null ? null : builder.getBuilder();
    }

    @Override
    public void selectNodeFromPsi(@Nullable PsiElement element) {
        if (this.myStubTreeBuilder == null || element == null) {
            return;
        }
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof PsiFileWithStubSupport)) {
            return;
        }
        StubTreeNode rootNode = (StubTreeNode)((Object)this.myStubTreeBuilder.getRootElement());
        if (rootNode == null) {
            return;
        }
        StubElement<?> stub = rootNode.getStub();
        if (!(stub instanceof PsiFileStub)) {
            return;
        }
        if (Boolean.TRUE.equals(((PsiFileStub)stub).getUserData(PSI_ELEMENT_SELECTION_REQUESTOR))) {
            return;
        }
        ((PsiFileStub)stub).putUserData(PSI_ELEMENT_SELECTION_REQUESTOR, (Object)true);
        final StubElement stubElement = this.myNodeToStubs.get(element.getNode());
        if (stubElement != null) {
            this.myStubTreeBuilder.select(StubTreeNode.class, (TreeVisitor)new TreeVisitor<StubTreeNode>(){

                public boolean visit(@NotNull StubTreeNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return node.getStub() == stubElement;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/internal/psiView/stubtree/StubViewerPsiBasedTree$1", "visit"));
                }
            }, () -> ((PsiFileStub)stub).putUserData(PSI_ELEMENT_SELECTION_REQUESTOR, (Object)false), false);
        } else {
            this.myStubTreeBuilder.getUi().getTree().clearSelection();
            ((PsiFileStub)stub).putUserData(PSI_ELEMENT_SELECTION_REQUESTOR, (Object)false);
        }
    }

    public PsiElement getPsiElementForStub(StubElement<?> stub) {
        Ref result2 = Ref.create();
        this.myNodeToStubs.forEach((key2, value2) -> {
            if (value2 == stub) {
                result2.set((Object)key2.getPsi());
            }
        });
        return (PsiElement)result2.get();
    }

    private void fillPsiToStubCache(@NotNull PsiFileWithStubSupport rootElement, @NotNull PsiFileStub rootStub) {
        if (rootElement == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(8);
        }
        if (rootStub == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(9);
        }
        this.fillTreeForStub(rootElement, new StubTree(rootStub));
    }

    public void fillTreeForStub(@NotNull PsiFileWithStubSupport file2, @NotNull StubTree tree) {
        StubBuilder builder;
        if (file2 == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(10);
        }
        if (tree == null) {
            StubViewerPsiBasedTree.$$$reportNull$$$0(11);
        }
        StubBuilder stubBuilder = builder = file2 instanceof PsiFileImpl ? StubViewerPsiBasedTree.getStubBuilder((PsiFileImpl)file2) : null;
        if (builder == null) {
            return;
        }
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement root = (StubElement)stubs.next();
        FileASTNode ast = file2.getNode();
        this.myNodeToStubs.put((ASTNode)ast, root);
        this.findTreeForStub(builder, (ASTNode)ast, stubs);
        if (stubs.hasNext()) {
            LOG.error("Stub mismatch, unprocessed stubs " + stubs.next());
        }
    }

    private void findTreeForStub(StubBuilder builder, ASTNode tree, Iterator<StubElement<?>> stubs) {
        IElementType type2 = tree.getElementType();
        if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(tree)) {
            if (!stubs.hasNext()) {
                LOG.error("Stub mismatch, " + type2);
            }
            StubElement<?> curStub = stubs.next();
            this.myNodeToStubs.put(tree, curStub);
        }
        for (ASTNode node : tree.getChildren(null)) {
            if (builder.skipChildProcessingWhenBuildingStubs(tree, node)) continue;
            this.findTreeForStub(builder, node, stubs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/psiView/stubtree/StubViewerPsiBasedTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToParse";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/psiView/stubtree/StubViewerPsiBasedTree";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reloadTree";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildStubForElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStubBuilder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillPsiToStubCache";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillTreeForStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StubTreeSelectionListener
    implements TreeSelectionListener {
        @NotNull
        private PsiFileWithStubSupport myFile;

        public StubTreeSelectionListener(PsiFileWithStubSupport element) {
            if (element == null) {
                StubTreeSelectionListener.$$$reportNull$$$0(0);
            }
            this.myFile = element;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            StubElement<?> topLevelStub;
            if (StubViewerPsiBasedTree.this.myStubTreeBuilder == null) {
                return;
            }
            StubTreeNode rootNode = (StubTreeNode)((Object)StubViewerPsiBasedTree.this.myStubTreeBuilder.getRootElement());
            StubElement<?> stubElement = topLevelStub = rootNode == null ? null : rootNode.getStub();
            if (!(topLevelStub instanceof PsiFileStub)) {
                return;
            }
            PsiFileStub stubFile = (PsiFileStub)topLevelStub;
            if (Boolean.TRUE.equals(stubFile.getUserData(PSI_ELEMENT_SELECTION_REQUESTOR))) {
                return;
            }
            Set blockElementsSet = StubViewerPsiBasedTree.this.myStubTreeBuilder.getSelectedElements();
            Object item = ContainerUtil.getFirstItem((Collection)blockElementsSet);
            if (!(item instanceof StubTreeNode)) {
                return;
            }
            StubElement<?> stub = ((StubTreeNode)((Object)item)).getStub();
            PsiElement result2 = StubViewerPsiBasedTree.this.getPsiElementForStub(stub);
            if (result2 != null) {
                StubViewerPsiBasedTree.this.myUpdater.updatePsiTree(result2, StubViewerPsiBasedTree.this.myStubTree.hasFocus() ? result2.getTextRange() : null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/internal/psiView/stubtree/StubViewerPsiBasedTree$StubTreeSelectionListener", "<init>"));
        }
    }
}

