/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.customUsageCollectors.actions;

import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ActionsCollector", storages={@Storage(value="statistics.actions.xml", roamingType=RoamingType.DISABLED)})
public class ActionsCollector
implements PersistentStateComponent<State> {
    private State myState = new State();

    public void record(String actionId) {
        if (actionId == null) {
            return;
        }
        State state = this.getState();
        if (state == null) {
            return;
        }
        String key2 = ConvertUsagesUtil.escapeDescriptorName(actionId);
        Integer count = state.myValues.get(key2);
        int value2 = count == null ? 1 : count + 1;
        state.myValues.put(key2, value2);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static ActionsCollector getInstance() {
        return (ActionsCollector)ServiceManager.getService(ActionsCollector.class);
    }

    static final class ActionUsagesCollector
    extends UsagesCollector {
        private static final GroupDescriptor GROUP = GroupDescriptor.create("Actions", 100.0);

        ActionUsagesCollector() {
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() {
            State state = ActionsCollector.getInstance().getState();
            assert (state != null);
            Set set2 = ContainerUtil.map2Set(state.myValues.entrySet(), e -> new UsageDescriptor((String)e.getKey(), (Integer)e.getValue()));
            if (set2 == null) {
                ActionUsagesCollector.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP;
            if (groupDescriptor == null) {
                ActionUsagesCollector.$$$reportNull$$$0(1);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/customUsageCollectors/actions/ActionsCollector$ActionUsagesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="action", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();

        State() {
        }
    }
}

