/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarStatisticsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarUsagesCollector
extends AbstractProjectsUsagesCollector {
    private static final GroupDescriptor GROUP = GroupDescriptor.create("Libraries by jars", -100.0);
    private static final String DIGIT_VERSION_PATTERN_PART = "(\\d+.\\d+|\\d+)";
    private static final Pattern JAR_FILE_NAME_PATTERN = Pattern.compile("[\\w|\\-|\\.]+-((\\d+.\\d+|\\d+)[\\w|\\.]*)jar");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) {
        if (project2 == null) {
            LibraryJarUsagesCollector.$$$reportNull$$$0(0);
        }
        LibraryJarDescriptor[] descriptors = LibraryJarStatisticsService.getInstance().getTechnologyDescriptors();
        HashSet result2 = new HashSet(descriptors.length);
        ApplicationManager.getApplication().runReadAction(() -> LibraryJarUsagesCollector.lambda$getProjectUsages$0(descriptors, project2, (Set)result2));
        HashSet hashSet = result2;
        if (hashSet == null) {
            LibraryJarUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    private static String getVersionByJarManifest(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibraryJarUsagesCollector.$$$reportNull$$$0(2);
        }
        return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Nullable
    private static String getVersionByJarFileName(@NotNull String fileName) {
        Matcher fileNameMatcher;
        if (fileName == null) {
            LibraryJarUsagesCollector.$$$reportNull$$$0(3);
        }
        if (!(fileNameMatcher = JAR_FILE_NAME_PATTERN.matcher(fileName)).matches()) {
            return null;
        }
        return StringUtil.trimTrailing((String)fileNameMatcher.group(1), (char)'.');
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GROUP;
        if (groupDescriptor == null) {
            LibraryJarUsagesCollector.$$$reportNull$$$0(4);
        }
        return groupDescriptor;
    }

    private static /* synthetic */ void lambda$getProjectUsages$0(LibraryJarDescriptor[] descriptors, @NotNull Project project2, Set result2) {
        if (project2 == null) {
            LibraryJarUsagesCollector.$$$reportNull$$$0(5);
        }
        for (LibraryJarDescriptor descriptor2 : descriptors) {
            PsiClass[] psiClasses;
            String className = descriptor2.myClass;
            if (className == null) continue;
            for (PsiClass psiClass : psiClasses = JavaPsiFacade.getInstance((Project)project2).findClasses(className, ProjectScope.getLibrariesScope((Project)project2))) {
                VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(psiClass.getContainingFile().getVirtualFile());
                if (jarFile == null) continue;
                String version = LibraryJarUsagesCollector.getVersionByJarManifest(jarFile);
                if (version == null) {
                    version = LibraryJarUsagesCollector.getVersionByJarFileName(jarFile.getName());
                }
                if (version == null || !StringUtil.containsChar((String)version, (char)'.')) continue;
                result2.add(new UsageDescriptor(descriptor2.myName + "_" + version, 1));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/libraryJar/LibraryJarUsagesCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/libraryJar/LibraryJarUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVersionByJarManifest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVersionByJarFileName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

