/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JsonLiteralAnnotator
implements Annotator {
    private static final Pattern VALID_ESCAPE = Pattern.compile("\\\\([\"\\\\/bfnrt]|u[0-9a-fA-F]{4})");
    private static final Pattern VALID_NUMBER_LITERAL = Pattern.compile("-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+-]?[0-9]+)?");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            JsonLiteralAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JsonLiteralAnnotator.$$$reportNull$$$0(1);
        }
        String text2 = JsonPsiUtil.getElementTextWithoutHostEscaping(element);
        if (element instanceof JsonStringLiteral) {
            int length;
            JsonStringLiteral stringLiteral = (JsonStringLiteral)element;
            int elementOffset = element.getTextOffset();
            if (JsonPsiUtil.isPropertyKey(element)) {
                holder.createInfoAnnotation(element, Holder.DEBUG ? "property key" : null).setTextAttributes(JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY);
            }
            if ((length = text2.length()) <= 1 || text2.charAt(0) != text2.charAt(length - 1) || JsonPsiUtil.isEscapedChar(text2, length - 1)) {
                holder.createErrorAnnotation(element, JsonBundle.message("syntax.error.missing.closing.quote", new Object[0]));
            }
            List<Pair<TextRange, String>> fragments = stringLiteral.getTextFragments();
            for (Pair<TextRange, String> fragment : fragments) {
                String fragmentText = (String)fragment.getSecond();
                if (!fragmentText.startsWith("\\") || fragmentText.length() <= 1 || VALID_ESCAPE.matcher(fragmentText).matches()) continue;
                TextRange fragmentRange = (TextRange)fragment.getFirst();
                if (fragmentText.startsWith("\\u")) {
                    holder.createErrorAnnotation(fragmentRange.shiftRight(elementOffset), JsonBundle.message("syntax.error.illegal.unicode.escape.sequence", new Object[0]));
                    continue;
                }
                holder.createErrorAnnotation(fragmentRange.shiftRight(elementOffset), JsonBundle.message("syntax.error.illegal.escape.sequence", new Object[0]));
            }
        } else if (element instanceof JsonNumberLiteral && !VALID_NUMBER_LITERAL.matcher(text2).matches()) {
            holder.createErrorAnnotation(element, JsonBundle.message("syntax.error.illegal.floating.point.literal", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/json/codeinsight/JsonLiteralAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();

        private Holder() {
        }
    }
}

