/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.google.common.collect.HashMultiset;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaImportOptimizer
implements ImportOptimizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.java.JavaImportOptimizer");

    @NotNull
    public Runnable processFile(final PsiFile file2) {
        if (!(file2 instanceof PsiJavaFile)) {
            Runnable runnable2 = EmptyRunnable.getInstance();
            if (runnable2 == null) {
                JavaImportOptimizer.$$$reportNull$$$0(0);
            }
            return runnable2;
        }
        Project project2 = file2.getProject();
        final PsiImportList newImportList = JavaCodeStyleManager.getInstance((Project)project2).prepareOptimizeImportsResult((PsiJavaFile)file2);
        if (newImportList == null) {
            Runnable runnable3 = EmptyRunnable.getInstance();
            if (runnable3 == null) {
                JavaImportOptimizer.$$$reportNull$$$0(1);
            }
            return runnable3;
        }
        ImportOptimizer.CollectingInfoRunnable collectingInfoRunnable = new ImportOptimizer.CollectingInfoRunnable(){
            private int myImportsAdded;
            private int myImportsRemoved;

            public void run() {
                try {
                    PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
                    Document document = manager.getDocument(file2);
                    if (document != null) {
                        manager.commitDocument(document);
                    }
                    PsiImportList oldImportList = ((PsiJavaFile)file2).getImportList();
                    assert (oldImportList != null);
                    HashMultiset oldImports = HashMultiset.create();
                    for (PsiImportStatement statement2 : oldImportList.getImportStatements()) {
                        oldImports.add((Object)statement2.resolve());
                    }
                    HashMultiset oldStaticImports = HashMultiset.create();
                    for (PsiImportStaticStatement psiImportStaticStatement : oldImportList.getImportStaticStatements()) {
                        oldStaticImports.add((Object)psiImportStaticStatement.resolve());
                    }
                    oldImportList.replace((PsiElement)newImportList);
                    for (PsiImportStaticStatement psiImportStaticStatement : newImportList.getImportStatements()) {
                        if (oldImports.remove((Object)psiImportStaticStatement.resolve())) continue;
                        ++this.myImportsAdded;
                    }
                    this.myImportsRemoved += oldImports.size();
                    for (PsiImportStaticStatement psiImportStaticStatement : newImportList.getImportStaticStatements()) {
                        if (oldStaticImports.remove((Object)psiImportStaticStatement.resolve())) continue;
                        ++this.myImportsAdded;
                    }
                    this.myImportsRemoved += oldStaticImports.size();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public String getUserNotificationInfo() {
                if (this.myImportsRemoved == 0) {
                    return "rearranged imports";
                }
                StringBuilder notification = new StringBuilder("removed ").append(this.myImportsRemoved).append(" import");
                if (this.myImportsRemoved > 1) {
                    notification.append('s');
                }
                if (this.myImportsAdded > 0) {
                    notification.append(", added ").append(this.myImportsAdded).append(" import");
                    if (this.myImportsAdded > 1) {
                        notification.append('s');
                    }
                }
                return notification.toString();
            }
        };
        if (collectingInfoRunnable == null) {
            JavaImportOptimizer.$$$reportNull$$$0(2);
        }
        return collectingInfoRunnable;
    }

    public boolean supports(PsiFile file2) {
        return file2 instanceof PsiJavaFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/JavaImportOptimizer", "processFile"));
    }
}

