/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubTagListProvider {
    private static final Logger LOG = Logger.getInstance(GithubTagListProvider.class);
    private final String myUserName;
    private final String myRepositoryName;

    public GithubTagListProvider(@NotNull String userName, @NotNull String repositoryName) {
        if (userName == null) {
            GithubTagListProvider.$$$reportNull$$$0(0);
        }
        if (repositoryName == null) {
            GithubTagListProvider.$$$reportNull$$$0(1);
        }
        this.myUserName = userName;
        this.myRepositoryName = repositoryName;
    }

    @Nullable
    public ImmutableSet<GithubTagInfo> getCachedTags() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        File cacheFile = this.getTagsCacheFile();
        if (cacheFile.isFile()) {
            try {
                ImmutableSet<GithubTagInfo> tags = this.readTagsFromFile(cacheFile);
                LOG.info(this.getGeneratorName() + "tag info list has been successfully read from cache file " + cacheFile.getAbsolutePath());
                return tags;
            }
            catch (GeneratorException e) {
                LOG.warn("Can't read cache file " + cacheFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return null;
    }

    public void updateTagListAsynchronously(@NotNull GithubProjectGeneratorPeer peer) {
        if (peer == null) {
            GithubTagListProvider.$$$reportNull$$$0(2);
        }
        Runnable action = this.createUpdateTagListAction(peer);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            action.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(action);
        }
    }

    private Runnable createUpdateTagListAction(@NotNull GithubProjectGeneratorPeer peer) {
        if (peer == null) {
            GithubTagListProvider.$$$reportNull$$$0(3);
        }
        return () -> {
            if (peer == null) {
                GithubTagListProvider.$$$reportNull$$$0(13);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                peer.onTagsUpdated(Collections.emptySet());
                return;
            }
            String[] urls = this.formatTagListDownloadUrls();
            String firstErrorMessage = null;
            for (String url : urls) {
                String errorMessage;
                try {
                    ImmutableSet<GithubTagInfo> tags = this.fetchGithubTagsByUrl(url);
                    LOG.info(this.getGeneratorName() + "Cache has been successfully updated");
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (peer == null) {
                            GithubTagListProvider.$$$reportNull$$$0(14);
                        }
                        peer.onTagsUpdated((Set<GithubTagInfo>)tags);
                    });
                    return;
                }
                catch (IOException e) {
                    errorMessage = "Can not fetch tags from " + url;
                    LOG.warn(this.getGeneratorName() + errorMessage, (Throwable)e);
                }
                catch (GeneratorException e) {
                    errorMessage = "Malformed JSON received from " + url;
                    LOG.warn(this.getGeneratorName() + errorMessage, (Throwable)e);
                }
                if (firstErrorMessage != null) continue;
                firstErrorMessage = errorMessage;
            }
            if (firstErrorMessage != null) {
                peer.onTagsUpdateError(firstErrorMessage);
            }
        };
    }

    private ImmutableSet<GithubTagInfo> fetchGithubTagsByUrl(@NotNull String url) throws IOException, GeneratorException {
        if (url == null) {
            GithubTagListProvider.$$$reportNull$$$0(4);
        }
        LOG.info(this.getGeneratorName() + "starting cache update from " + url + " ...");
        File cacheFile = this.getTagsCacheFile();
        GithubDownloadUtil.downloadAtomically(null, url, cacheFile, this.myUserName, this.myRepositoryName);
        return this.readTagsFromFile(cacheFile);
    }

    private String getGeneratorName() {
        return "[" + this.myUserName + "/" + this.myRepositoryName + "] ";
    }

    @NotNull
    private ImmutableSet<GithubTagInfo> readTagsFromFile(@NotNull File file2) throws GeneratorException {
        ImmutableSet<GithubTagInfo> immutableSet;
        String content;
        if (file2 == null) {
            GithubTagListProvider.$$$reportNull$$$0(5);
        }
        try {
            content = Files.toString((File)file2, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new GeneratorException("Can not read '" + file2.getAbsolutePath() + "'!", e);
        }
        try {
            immutableSet = GithubTagListProvider.parseContent(content);
        }
        catch (GeneratorException e) {
            String message2 = String.format("%s parsing version list failed: %s\n%s", this.getGeneratorName(), e.getMessage(), content);
            LOG.info(message2, (Throwable)e);
            throw e;
        }
        if (immutableSet == null) {
            GithubTagListProvider.$$$reportNull$$$0(6);
        }
        return immutableSet;
    }

    @NotNull
    private static ImmutableSet<GithubTagInfo> parseContent(@NotNull String tagFileContent) throws GeneratorException {
        JsonElement jsonElement;
        if (tagFileContent == null) {
            GithubTagListProvider.$$$reportNull$$$0(7);
        }
        if (tagFileContent.trim().isEmpty()) {
            throw new GeneratorException("Can not parse fetched version list: got empty response");
        }
        try {
            JsonParser jsonParser = new JsonParser();
            jsonElement = jsonParser.parse(tagFileContent);
        }
        catch (Exception e) {
            throw new GeneratorException("Can not parse fetched version list: malformed JSON was received");
        }
        ImmutableSet<GithubTagInfo> immutableSet = GithubTagListProvider.toGithubTagList(jsonElement);
        if (immutableSet == null) {
            GithubTagListProvider.$$$reportNull$$$0(8);
        }
        return immutableSet;
    }

    @NotNull
    private static ImmutableSet<GithubTagInfo> toGithubTagList(@NotNull JsonElement jsonElement) throws GeneratorException {
        if (jsonElement == null) {
            GithubTagListProvider.$$$reportNull$$$0(9);
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            ImmutableSet.Builder tags = ImmutableSet.builder();
            for (JsonElement element : array) {
                if (element instanceof JsonObject) {
                    JsonObject obj = (JsonObject)element;
                    JsonElement nameElement = obj.get("name");
                    String name2 = null;
                    if (nameElement != null) {
                        name2 = nameElement.getAsString();
                    }
                    String zipball = null;
                    JsonElement zipballElement = obj.get("zipball_url");
                    if (zipballElement != null) {
                        zipball = zipballElement.getAsString();
                    }
                    if (name2 == null || zipball == null) continue;
                    tags.add((Object)new GithubTagInfo(name2, zipball));
                    continue;
                }
                throw new GeneratorException("Unexpected child element " + element.getClass().getName());
            }
            ImmutableSet immutableSet = tags.build();
            if (immutableSet == null) {
                GithubTagListProvider.$$$reportNull$$$0(10);
            }
            return immutableSet;
        }
        throw new GeneratorException("jsonElement is expected be instance of " + JsonArray.class.getName());
    }

    @NotNull
    private File getTagsCacheFile() {
        File dir = GithubDownloadUtil.getCacheDir(this.myUserName, this.myRepositoryName);
        File file2 = new File(dir, "tags.json");
        if (file2 == null) {
            GithubTagListProvider.$$$reportNull$$$0(11);
        }
        return file2;
    }

    @NotNull
    private String[] formatTagListDownloadUrls() {
        String[] stringArray = new String[]{"https://api.github.com/repos/" + this.myUserName + "/" + this.myRepositoryName + "/tags", "http://download.jetbrains.com/idea/project_templates/github-tags/" + this.myUserName + "-" + this.myRepositoryName + "-tags.json"};
        if (stringArray == null) {
            GithubTagListProvider.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryName";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/GithubTagListProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagFileContent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/GithubTagListProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readTagsFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toGithubTagList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagsCacheFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTagListDownloadUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateTagListAsynchronously";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateTagListAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchGithubTagsByUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readTagsFromFile";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toGithubTagList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createUpdateTagListAction$1";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

