/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlatformUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DirectoryPresentationProvider
implements ItemPresentationProvider<PsiDirectory> {
    public ItemPresentation getPresentation(@NotNull PsiDirectory directory) {
        SourceFolder sourceRoot;
        if (directory == null) {
            DirectoryPresentationProvider.$$$reportNull$$$0(0);
        }
        VirtualFile vFile = directory.getVirtualFile();
        Project project2 = directory.getProject();
        String locationString = vFile.getPath();
        if (ProjectRootsUtil.isProjectHome(directory)) {
            Icon projectIcon = PlatformUtils.isJetBrainsProduct() ? AllIcons.Nodes.IdeaProject : IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl());
            return new PresentationData(project2.getName(), locationString, projectIcon, null);
        }
        if (ProjectRootsUtil.isModuleContentRoot(directory)) {
            Module module2 = ProjectRootManager.getInstance((Project)project2).getFileIndex().getModuleForFile(vFile);
            assert (module2 != null) : directory;
            return new PresentationData(module2.getName(), locationString, PlatformIcons.CONTENT_ROOT_ICON_CLOSED, null);
        }
        if (ProjectRootsUtil.isSourceRoot(directory) && (sourceRoot = ProjectRootsUtil.getModuleSourceRoot(vFile, project2)) != null) {
            Icon icon = SourceRootPresentation.getSourceRootIcon(sourceRoot);
            return new PresentationData(directory.getName(), locationString, icon, null);
        }
        return new PresentationData(directory.getName(), locationString, PlatformIcons.DIRECTORY_CLOSED_ICON, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/navigation/DirectoryPresentationProvider", "getPresentation"));
    }
}

