/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.notification.EventLog;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EventLogConsole {
    private static final Key<String> GROUP_ID = Key.create((String)"GROUP_ID");
    private static final Key<String> NOTIFICATION_ID = Key.create((String)"NOTIFICATION_ID");
    private final NotNullLazyValue<Editor> myLogEditor = new NotNullLazyValue<Editor>(){

        @NotNull
        protected Editor compute() {
            Editor editor = EventLogConsole.this.createLogEditor();
            if (editor == null) {
                1.$$$reportNull$$$0(0);
            }
            return editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLogConsole$1", "compute"));
        }
    };
    private final NotNullLazyValue<EditorHyperlinkSupport> myHyperlinkSupport = new NotNullLazyValue<EditorHyperlinkSupport>(){

        @NotNull
        protected EditorHyperlinkSupport compute() {
            EditorHyperlinkSupport editorHyperlinkSupport = new EditorHyperlinkSupport(EventLogConsole.this.getConsoleEditor(), EventLogConsole.this.myProjectModel.getProject());
            if (editorHyperlinkSupport == null) {
                2.$$$reportNull$$$0(0);
            }
            return editorHyperlinkSupport;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLogConsole$2", "compute"));
        }
    };
    private final LogModel myProjectModel;
    private String myLastDate;
    private List<RangeHighlighter> myNMoreHighlighters;

    EventLogConsole(LogModel model) {
        this.myProjectModel = model;
    }

    private Editor createLogEditor() {
        Project project2 = this.myProjectModel.getProject();
        final EditorEx editor = ConsoleViewUtil.setupConsoleEditor(project2, false, false);
        editor.getSettings().setWhitespacesShown(false);
        this.installNotificationsFont(editor);
        this.myProjectModel.getProject().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(Project project2) {
                if (project2 == EventLogConsole.this.myProjectModel.getProject()) {
                    EditorFactory.getInstance().releaseEditor((Editor)editor);
                }
            }
        });
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        final ClearLogAction clearLog = new ClearLogAction(this);
        clearLog.registerCustomShortcutSet(ActionManager.getInstance().getAction("ConsoleView.ClearAll").getShortcutSet(), editor.getContentComponent());
        editor.setContextMenuGroupId(null);
        editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                ActionManager actionManager = ActionManager.getInstance();
                DefaultActionGroup actions = EventLogConsole.createPopupActions(actionManager, clearLog, editor, event);
                ActionPopupMenu menu = actionManager.createActionPopupMenu("EditorPopup", (ActionGroup)actions);
                MouseEvent mouseEvent = event.getMouseEvent();
                menu.getComponent().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        return editor;
    }

    private void installNotificationsFont(final @NotNull EditorEx editor) {
        if (editor == null) {
            EventLogConsole.$$$reportNull$$$0(0);
        }
        final DelegateColorScheme globalScheme = new DelegateColorScheme(EditorColorsManager.getInstance().getGlobalScheme()){

            @Override
            public String getEditorFontName() {
                return this.getConsoleFontName();
            }

            @Override
            public int getEditorFontSize() {
                return this.getConsoleFontSize();
            }

            @Override
            public String getConsoleFontName() {
                return NotificationsUtil.getFontName();
            }

            @Override
            public int getConsoleFontSize() {
                Pair<String, Integer> data = NotificationsUtil.getFontData();
                return data == null ? super.getConsoleFontSize() : ((Integer)data.second).intValue();
            }

            @Override
            public void setEditorFontName(String fontName) {
            }

            @Override
            public void setConsoleFontName(String fontName) {
            }

            @Override
            public void setEditorFontSize(int fontSize) {
            }

            @Override
            public void setConsoleFontSize(int fontSize) {
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProjectModel).subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme2) {
                globalScheme.setDelegate(EditorColorsManager.getInstance().getGlobalScheme());
                editor.reinitSettings();
            }
        });
        editor.setColorsScheme(ConsoleViewUtil.updateConsoleColorScheme(editor.createBoundColorSchemeDelegate(globalScheme)));
        if (editor instanceof EditorImpl) {
            ((EditorImpl)editor).setUseEditorAntialiasing(false);
        }
    }

    private static DefaultActionGroup createPopupActions(ActionManager actionManager, ClearLogAction action, EditorEx editor, EditorMouseEvent event) {
        AnAction[] children2 = ((ActionGroup)actionManager.getAction("ConsoleEditorPopupMenu")).getChildren(null);
        DefaultActionGroup group = new DefaultActionGroup();
        EventLogConsole.addConfigureNotificationAction(editor, event, group);
        group.addAll(children2);
        group.addSeparator();
        group.add((AnAction)action);
        return group;
    }

    private static void addConfigureNotificationAction(@NotNull EditorEx editor, @NotNull EditorMouseEvent event, @NotNull DefaultActionGroup actions) {
        LogicalPosition position;
        if (editor == null) {
            EventLogConsole.$$$reportNull$$$0(1);
        }
        if (event == null) {
            EventLogConsole.$$$reportNull$$$0(2);
        }
        if (actions == null) {
            EventLogConsole.$$$reportNull$$$0(3);
        }
        if (EditorUtil.inVirtualSpace(editor, position = editor.xyToLogicalPosition(event.getMouseEvent().getPoint()))) {
            return;
        }
        int offset = editor.logicalPositionToOffset(position);
        editor.getMarkupModel().processRangeHighlightersOverlappingWith(offset, offset, (Processor<? super RangeHighlighterEx>)((Processor)rangeHighlighter -> {
            String groupId;
            if (actions == null) {
                EventLogConsole.$$$reportNull$$$0(10);
            }
            if ((groupId = (String)GROUP_ID.get((UserDataHolder)rangeHighlighter)) != null) {
                EventLogConsole.addConfigureNotificationAction(actions, groupId);
                return false;
            }
            return true;
        }));
    }

    private static void addConfigureNotificationAction(@NotNull DefaultActionGroup actions, @NotNull String groupId) {
        if (actions == null) {
            EventLogConsole.$$$reportNull$$$0(4);
        }
        if (groupId == null) {
            EventLogConsole.$$$reportNull$$$0(5);
        }
        DefaultActionGroup displayTypeGroup = new DefaultActionGroup("Notification Display Type", true);
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(groupId);
        NotificationDisplayType current = settings.getDisplayType();
        for (NotificationDisplayType type2 : NotificationDisplayType.values()) {
            if (type2 == NotificationDisplayType.TOOL_WINDOW && !NotificationsConfigurationImpl.getInstanceImpl().hasToolWindowCapability(groupId)) continue;
            displayTypeGroup.add((AnAction)new DisplayTypeAction(settings, type2, current));
        }
        actions.add((AnAction)displayTypeGroup);
        actions.addSeparator();
    }

    void doPrintNotification(Notification notification) {
        boolean scroll;
        Editor editor = this.getConsoleEditor();
        if (editor.isDisposed()) {
            return;
        }
        Document document = editor.getDocument();
        boolean bl = scroll = document.getTextLength() == editor.getCaretModel().getOffset() || !editor.getContentComponent().hasFocus();
        if (document.getTextLength() > 0) {
            EventLogConsole.append(document, "\n");
        }
        String lastDate = DateFormatUtil.formatDate((long)notification.getTimestamp());
        if (document.getTextLength() == 0 || !lastDate.equals(this.myLastDate)) {
            this.myLastDate = lastDate;
            EventLogConsole.append(document, lastDate + "\n");
        }
        int startDateOffset = document.getTextLength();
        String date = DateFormatUtil.formatTime((long)notification.getTimestamp()) + "\t";
        EventLogConsole.append(document, date);
        int tabs = EventLogConsole.calculateTabs(editor, startDateOffset);
        int titleStartOffset = document.getTextLength();
        int startLine = document.getLineCount() - 1;
        EventLog.LogEntry pair2 = EventLog.formatForLog(notification, StringUtil.repeatSymbol((char)'\t', (int)tabs));
        NotificationType type2 = notification.getType();
        TextAttributesKey key2 = type2 == NotificationType.ERROR ? ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY : (type2 == NotificationType.INFORMATION ? ConsoleViewContentType.NORMAL_OUTPUT_KEY : ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY);
        int msgStart = document.getTextLength();
        EventLogConsole.append(document, pair2.message);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key2);
        int layer = 2001;
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(msgStart, document.getTextLength(), layer, attributes, HighlighterTargetArea.LINES_IN_RANGE);
        GROUP_ID.set((UserDataHolder)highlighter, (Object)notification.getGroupId());
        NOTIFICATION_ID.set((UserDataHolder)highlighter, (Object)notification.id);
        for (Pair<TextRange, HyperlinkInfo> link : pair2.links) {
            RangeHighlighter rangeHighlighter = ((EditorHyperlinkSupport)this.myHyperlinkSupport.getValue()).createHyperlink(((TextRange)link.first).getStartOffset() + msgStart, ((TextRange)link.first).getEndOffset() + msgStart, null, (HyperlinkInfo)link.second);
            if (!(link.second instanceof EventLog.ShowBalloon)) continue;
            ((EventLog.ShowBalloon)link.second).setRangeHighlighter(rangeHighlighter);
        }
        EventLogConsole.append(document, "\n");
        if (scroll) {
            editor.getCaretModel().moveToOffset(document.getTextLength());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        if (notification.isImportant()) {
            this.highlightNotification(notification, pair2.status, startLine, document.getLineCount() - 1, titleStartOffset, pair2.titleLength);
        }
    }

    private static int calculateTabs(@NotNull Editor editor, int startDateOffset) {
        if (editor == null) {
            EventLogConsole.$$$reportNull$$$0(6);
        }
        Document document = editor.getDocument();
        int startOffset = document.getTextLength();
        Point dateStartPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startDateOffset));
        Point dateEndPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startOffset));
        int width = dateEndPoint.x - dateStartPoint.x;
        document.insertString(startOffset, (CharSequence)"\n");
        Point startPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startOffset + 1));
        int count = 1;
        while (true) {
            document.insertString(startOffset + count, (CharSequence)"\t");
            Point endPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(document.getTextLength()));
            int tabWidth = endPoint.x - startPoint.x;
            if (width <= tabWidth) {
                document.deleteString(startOffset, document.getTextLength());
                return count;
            }
            ++count;
        }
    }

    private void highlightNotification(Notification notification, String message2, int startLine, int endLine, int titleOffset, int titleLength) {
        MarkupModel markupModel = this.getConsoleEditor().getMarkupModel();
        TextAttributes bold = new TextAttributes(null, null, null, null, 1);
        RangeHighlighter colorHighlighter = markupModel.addRangeHighlighter(titleOffset, titleOffset + titleLength, 2001, bold, HighlighterTargetArea.EXACT_RANGE);
        JBColor color = notification.getType() == NotificationType.ERROR ? JBColor.RED : (notification.getType() == NotificationType.WARNING ? JBColor.YELLOW : JBColor.GREEN);
        colorHighlighter.setErrorStripeMarkColor((Color)color);
        colorHighlighter.setErrorStripeTooltip((Object)message2);
        Runnable removeHandler = () -> {
            if (colorHighlighter.isValid()) {
                markupModel.removeHighlighter(colorHighlighter);
            }
            TextAttributes italic = new TextAttributes((Color)Gray.x80, null, null, null, 0);
            for (int line = startLine; line < endLine; ++line) {
                for (RangeHighlighter highlighter : ((EditorHyperlinkSupport)this.myHyperlinkSupport.getValue()).findAllHyperlinksOnLine(line)) {
                    markupModel.addRangeHighlighter(highlighter.getStartOffset(), highlighter.getEndOffset(), 2002, italic, HighlighterTargetArea.EXACT_RANGE);
                    ((EditorHyperlinkSupport)this.myHyperlinkSupport.getValue()).removeHyperlink(highlighter);
                }
            }
        };
        if (!notification.isExpired()) {
            this.myProjectModel.removeHandlers.put(notification, removeHandler);
        } else {
            removeHandler.run();
        }
    }

    public Editor getConsoleEditor() {
        return (Editor)this.myLogEditor.getValue();
    }

    public void clearNMore() {
        if (this.myNMoreHighlighters != null) {
            MarkupModel model = this.getConsoleEditor().getMarkupModel();
            for (RangeHighlighter highlighter : this.myNMoreHighlighters) {
                model.removeHighlighter(highlighter);
            }
            this.myNMoreHighlighters = null;
        }
    }

    public void showNotification(@NotNull List<String> ids) {
        if (ids == null) {
            EventLogConsole.$$$reportNull$$$0(7);
        }
        this.clearNMore();
        this.myNMoreHighlighters = new ArrayList<RangeHighlighter>();
        EditorEx editor = (EditorEx)this.getConsoleEditor();
        List highlighters = ContainerUtil.mapNotNull(ids, this::findHighlighter);
        if (!highlighters.isEmpty()) {
            editor.getCaretModel().moveToOffset(((RangeHighlighterEx)highlighters.get(0)).getStartOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_UP);
            ArrayList<Point> ranges = new ArrayList<Point>();
            Point currentRange = null;
            DocumentEx document = editor.getDocument();
            for (RangeHighlighterEx highlighter : highlighters) {
                int startLine = document.getLineNumber(highlighter.getStartOffset());
                int endLine = document.getLineNumber(highlighter.getEndOffset()) + 1;
                if (currentRange != null && startLine - 1 == currentRange.y) {
                    currentRange.y = endLine;
                    continue;
                }
                currentRange = new Point(startLine, endLine);
                ranges.add(currentRange);
            }
            TextAttributes attributes = new TextAttributes(null, ColorUtil.mix((Color)editor.getBackgroundColor(), (Color)new Color(0x808080), (double)0.1), null, EffectType.BOXED, 0);
            MarkupModelEx markupModel = editor.getMarkupModel();
            for (Point range : ranges) {
                int start = document.getLineStartOffset(range.x);
                int end = document.getLineStartOffset(range.y);
                this.myNMoreHighlighters.add(markupModel.addRangeHighlighter(start, end, 2002, attributes, HighlighterTargetArea.EXACT_RANGE));
            }
        }
    }

    @Nullable
    private RangeHighlighterEx findHighlighter(@NotNull String id) {
        if (id == null) {
            EventLogConsole.$$$reportNull$$$0(8);
        }
        EditorEx editor = (EditorEx)this.getConsoleEditor();
        Ref highlighter = new Ref();
        editor.getMarkupModel().processRangeHighlightersOverlappingWith(0, editor.getDocument().getTextLength(), (Processor<? super RangeHighlighterEx>)((Processor)rangeHighlighter -> {
            if (id == null) {
                EventLogConsole.$$$reportNull$$$0(9);
            }
            if (id.equals(NOTIFICATION_ID.get((UserDataHolder)rangeHighlighter))) {
                highlighter.set(rangeHighlighter);
                return false;
            }
            return true;
        }));
        return (RangeHighlighterEx)highlighter.get();
    }

    @Nullable
    public RelativePoint getRangeHighlighterLocation(RangeHighlighter range) {
        Editor editor = this.getConsoleEditor();
        Project project2 = editor.getProject();
        Window window = NotificationsManagerImpl.findWindowForBalloon(project2);
        if (range != null && window != null) {
            Point point = editor.visualPositionToXY(editor.offsetToVisualPosition(range.getStartOffset()));
            return new RelativePoint((Component)window, SwingUtilities.convertPoint(editor.getContentComponent(), point, window));
        }
        return null;
    }

    private static void append(Document document, String s) {
        document.insertString(document.getTextLength(), (CharSequence)s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/notification/EventLogConsole";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installNotificationsFont";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addConfigureNotificationAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateTabs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findHighlighter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findHighlighter$2";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addConfigureNotificationAction$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ClearLogAction
    extends DumbAwareAction {
        private EventLogConsole myConsole;

        public ClearLogAction(EventLogConsole console) {
            super("Clear All", "Clear the contents of the Event Log", AllIcons.Actions.GC);
            this.myConsole = console;
        }

        public void update(AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            e.getPresentation().setEnabled(editor != null && editor.getDocument().getTextLength() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            LogModel model = this.myConsole.myProjectModel;
            for (Notification notification : model.getNotifications()) {
                notification.expire();
                model.removeNotification(notification);
            }
            model.setStatusMessage(null, 0L);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                editor.getDocument().deleteString(0, editor.getDocument().getTextLength());
            }
        }
    }

    private static class DisplayTypeAction
    extends ToggleAction {
        private final NotificationSettings mySettings;
        private final NotificationDisplayType myType;
        private final NotificationDisplayType myCurrent;

        public DisplayTypeAction(@NotNull NotificationSettings settings, @NotNull NotificationDisplayType type2, @NotNull NotificationDisplayType current) {
            if (settings == null) {
                DisplayTypeAction.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                DisplayTypeAction.$$$reportNull$$$0(1);
            }
            if (current == null) {
                DisplayTypeAction.$$$reportNull$$$0(2);
            }
            super(type2.getTitle());
            this.mySettings = settings;
            this.myType = type2;
            this.myCurrent = current;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myType == this.myCurrent;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                NotificationsConfigurationImpl.getInstanceImpl().changeSettings(this.mySettings.withDisplayType(this.myType));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "current";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/EventLogConsole$DisplayTypeAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

