/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwoSideChange<T extends SideChange>
extends ChangeSide
implements DiffRangeMarker.RangeInvalidListener {
    @NotNull
    protected final MergeList myMergeList;
    @NotNull
    protected DiffRangeMarker myBaseRangeMarker;
    protected T myLeftChange;
    protected T myRightChange;
    @NotNull
    protected final ChangeHighlighterHolder myCommonHighlighterHolder;

    protected TwoSideChange(@NotNull TextRange baseRange, @NotNull MergeList mergeList, @NotNull ChangeHighlighterHolder highlighterHolder) {
        if (baseRange == null) {
            TwoSideChange.$$$reportNull$$$0(0);
        }
        if (mergeList == null) {
            TwoSideChange.$$$reportNull$$$0(1);
        }
        if (highlighterHolder == null) {
            TwoSideChange.$$$reportNull$$$0(2);
        }
        this.myBaseRangeMarker = new DiffRangeMarker((DocumentEx)mergeList.getBaseDocument(), baseRange, this);
        this.myMergeList = mergeList;
        this.myCommonHighlighterHolder = highlighterHolder;
    }

    @Override
    @NotNull
    public ChangeHighlighterHolder getHighlighterHolder() {
        ChangeHighlighterHolder changeHighlighterHolder = this.myCommonHighlighterHolder;
        if (changeHighlighterHolder == null) {
            TwoSideChange.$$$reportNull$$$0(3);
        }
        return changeHighlighterHolder;
    }

    @Override
    @NotNull
    public DiffRangeMarker getRange() {
        DiffRangeMarker diffRangeMarker = this.myBaseRangeMarker;
        if (diffRangeMarker == null) {
            TwoSideChange.$$$reportNull$$$0(4);
        }
        return diffRangeMarker;
    }

    @Nullable
    public Change getLeftChange() {
        return this.myLeftChange;
    }

    @Nullable
    public Change getRightChange() {
        return this.myRightChange;
    }

    public void setRange(@NotNull DiffRangeMarker range) {
        if (range == null) {
            TwoSideChange.$$$reportNull$$$0(5);
        }
        this.myBaseRangeMarker = range;
    }

    @Nullable
    T getOtherChange(@NotNull T change) {
        if (change == null) {
            TwoSideChange.$$$reportNull$$$0(6);
        }
        if (change == this.myLeftChange) {
            return this.myRightChange;
        }
        if (change == this.myRightChange) {
            return this.myLeftChange;
        }
        throw new IllegalStateException("Unexpected change: " + change);
    }

    public void removeOtherChange(@NotNull T change) {
        if (change == null) {
            TwoSideChange.$$$reportNull$$$0(7);
        }
        if (change == this.myLeftChange) {
            this.myRightChange = null;
        } else if (change == this.myRightChange) {
            this.myLeftChange = null;
        } else {
            throw new IllegalStateException("Unexpected change: " + change);
        }
    }

    public void conflictRemoved() {
        TwoSideChange.removeHighlighters(this.myLeftChange);
        TwoSideChange.removeHighlighters(this.myRightChange);
        this.myCommonHighlighterHolder.removeHighlighters();
        this.myMergeList.removeChanges((Change)this.myLeftChange, (Change)this.myRightChange);
        this.myBaseRangeMarker.removeListener(this);
    }

    private static <T extends SideChange> void removeHighlighters(@Nullable T change) {
        if (change != null) {
            change.getOriginalSide().getHighlighterHolder().removeHighlighters();
        }
    }

    @NotNull
    public Document getOriginalDocument(FragmentSide mergeSide) {
        Document document = this.myMergeList.getChanges(mergeSide).getDocument(MergeList.BRANCH_SIDE);
        if (document == null) {
            TwoSideChange.$$$reportNull$$$0(8);
        }
        return document;
    }

    @Override
    public void onRangeInvalidated() {
        this.conflictRemoved();
    }

    @NotNull
    public MergeList getMergeList() {
        MergeList mergeList = this.myMergeList;
        if (mergeList == null) {
            TwoSideChange.$$$reportNull$$$0(9);
        }
        return mergeList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighterHolder";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighterHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalDocument";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOtherChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeOtherChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class SideChange<V extends TwoSideChange>
    extends Change
    implements DiffRangeMarker.RangeInvalidListener {
        protected V myTwoSideChange;
        @NotNull
        protected final ChangeList myChangeList;
        protected Change.SimpleChangeSide myOriginalSide;
        @NotNull
        protected ChangeType myType;

        protected SideChange(@NotNull V twoSideChange, @NotNull ChangeList changeList, @NotNull ChangeType type2, @NotNull FragmentSide mergeSide, @NotNull TextRange versionRange) {
            if (twoSideChange == null) {
                SideChange.$$$reportNull$$$0(0);
            }
            if (changeList == null) {
                SideChange.$$$reportNull$$$0(1);
            }
            if (type2 == null) {
                SideChange.$$$reportNull$$$0(2);
            }
            if (mergeSide == null) {
                SideChange.$$$reportNull$$$0(3);
            }
            if (versionRange == null) {
                SideChange.$$$reportNull$$$0(4);
            }
            this.myTwoSideChange = twoSideChange;
            this.myChangeList = changeList;
            this.myOriginalSide = new Change.SimpleChangeSide(mergeSide, new DiffRangeMarker((DocumentEx)((TwoSideChange)twoSideChange).getOriginalDocument(mergeSide), versionRange, this));
            this.myType = type2;
        }

        @Override
        @NotNull
        public ChangeType getType() {
            ChangeType changeType = this.myType;
            if (changeType == null) {
                SideChange.$$$reportNull$$$0(5);
            }
            return changeType;
        }

        public Change.SimpleChangeSide getOriginalSide() {
            return this.myOriginalSide;
        }

        protected void markApplied() {
            this.myType = ChangeType.deriveApplied(this.myType);
            this.myChangeList.apply(this);
            this.myOriginalSide.getHighlighterHolder().updateHighlighter(this.myOriginalSide, this.myType);
            this.myOriginalSide.getHighlighterHolder().setActions(AnAction.EMPTY_ARRAY);
            ((TwoSideChange)this.myTwoSideChange).getHighlighterHolder().updateHighlighter((ChangeSide)this.myTwoSideChange, this.myType);
        }

        @Override
        public ChangeList getChangeList() {
            return ((TwoSideChange)this.myTwoSideChange).getMergeList().getChanges(this.myOriginalSide.getFragmentSide());
        }

        @Override
        protected void changeSide(ChangeSide sideToChange, DiffRangeMarker newRange) {
            ((TwoSideChange)this.myTwoSideChange).setRange(newRange);
        }

        @Override
        @NotNull
        public ChangeSide getChangeSide(@NotNull FragmentSide side) {
            if (side == null) {
                SideChange.$$$reportNull$$$0(6);
            }
            Change.SimpleChangeSide simpleChangeSide = SideChange.isBranch(side) ? this.myOriginalSide : this.myTwoSideChange;
            if (simpleChangeSide == null) {
                SideChange.$$$reportNull$$$0(7);
            }
            return simpleChangeSide;
        }

        protected static boolean isBranch(@NotNull FragmentSide side) {
            if (side == null) {
                SideChange.$$$reportNull$$$0(8);
            }
            return MergeList.BRANCH_SIDE == side;
        }

        @Override
        protected void removeFromList() {
            ((TwoSideChange)this.myTwoSideChange).conflictRemoved();
            this.myTwoSideChange = null;
        }

        @Override
        public boolean isValid() {
            return this.myTwoSideChange != null;
        }

        @Override
        public void onRemovedFromList() {
            this.myOriginalSide.getRange().removeListener(this);
            this.myTwoSideChange = null;
            this.myOriginalSide = null;
        }

        @Override
        public void onRangeInvalidated() {
            this.removeFromList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "twoSideChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeSide";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionRange";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/TwoSideChange$SideChange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getChangeSide";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isBranch";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

