/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchFactory;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathsVerifier<BinaryType extends FilePatch> {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    private final List<FilePatch> myPatches;
    private final Map<VirtualFile, MovedFileData> myMovedFiles;
    private final List<FilePath> myBeforePaths;
    private final List<VirtualFile> myCreatedDirectories;
    private final List<Pair<VirtualFile, ApplyTextFilePatch>> myTextPatches;
    private final List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> myBinaryPatches;
    @NotNull
    private final List<VirtualFile> myWritableFiles;
    private final BaseMapper myBaseMapper;
    private ProjectLevelVcsManager myVcsManager;
    private final List<FilePatch> mySkipped;
    private DelayedPrecheckContext myDelayedPrecheckContext;
    private List<FilePath> myAddedPaths;
    private List<FilePath> myDeletedPaths;
    private boolean myIgnoreContentRootsCheck;

    public PathsVerifier(Project project2, VirtualFile baseDirectory, List<FilePatch> patches, BaseMapper baseMapper) {
        this.myProject = project2;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myBaseMapper = baseMapper;
        this.myMovedFiles = new HashMap<VirtualFile, MovedFileData>();
        this.myBeforePaths = new ArrayList<FilePath>();
        this.myCreatedDirectories = new ArrayList<VirtualFile>();
        this.myTextPatches = new ArrayList<Pair<VirtualFile, ApplyTextFilePatch>>();
        this.myBinaryPatches = new ArrayList<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>>();
        this.myWritableFiles = new ArrayList<VirtualFile>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.mySkipped = new ArrayList<FilePatch>();
        this.myAddedPaths = new ArrayList<FilePath>();
        this.myDeletedPaths = new ArrayList<FilePath>();
    }

    public List<FilePath> getDirectlyAffected() {
        ArrayList<FilePath> affected = new ArrayList<FilePath>();
        PathsVerifier.addAllFilePath(this.myCreatedDirectories, affected);
        PathsVerifier.addAllFilePath(this.myWritableFiles, affected);
        affected.addAll(this.myBeforePaths);
        return affected;
    }

    public List<VirtualFile> getAllAffected() {
        VirtualFile parent;
        ArrayList<VirtualFile> affected = new ArrayList<VirtualFile>();
        affected.addAll(this.myCreatedDirectories);
        affected.addAll(this.myWritableFiles);
        for (VirtualFile file2 : this.myMovedFiles.keySet()) {
            parent = file2.getParent();
            if (parent == null) continue;
            affected.add(parent);
        }
        for (FilePath path : this.myBeforePaths) {
            parent = path.getParentPath();
            if (parent == null) continue;
            affected.add(parent.getVirtualFile());
        }
        return affected;
    }

    private static void addAllFilePath(Collection<VirtualFile> files, Collection<FilePath> paths) {
        for (VirtualFile file2 : files) {
            paths.add(VcsUtil.getFilePath((VirtualFile)file2));
        }
    }

    public List<FilePatch> nonWriteActionPreCheck() {
        ArrayList failedToApply = ContainerUtil.newArrayList();
        this.myDelayedPrecheckContext = new DelayedPrecheckContext(this.myProject);
        for (FilePatch patch : this.myPatches) {
            CheckPath checker = this.getChecker(patch);
            if (checker.canBeApplied(this.myDelayedPrecheckContext)) continue;
            this.revert(checker.getErrorMessage());
            failedToApply.add(patch);
        }
        Collection<FilePatch> skipped = this.myDelayedPrecheckContext.doDelayed();
        this.mySkipped.addAll(skipped);
        this.myPatches.removeAll(skipped);
        this.myPatches.removeAll(failedToApply);
        return failedToApply;
    }

    public List<FilePatch> getSkipped() {
        return this.mySkipped;
    }

    public List<FilePatch> execute() {
        ArrayList failedPatches = ContainerUtil.newArrayList();
        try {
            ArrayList<CheckPath> checkers = new ArrayList<CheckPath>(this.myPatches.size());
            for (FilePatch patch : this.myPatches) {
                CheckPath checker = this.getChecker(patch);
                checkers.add(checker);
            }
            for (CheckPath checker : checkers) {
                if (checker.check()) continue;
                failedPatches.add(checker.getPatch());
                this.revert(checker.getErrorMessage());
            }
        }
        catch (IOException e) {
            this.revert(e.getMessage());
        }
        this.myPatches.removeAll(failedPatches);
        return failedPatches;
    }

    private CheckPath getChecker(FilePatch patch) {
        String beforeFileName = patch.getBeforeName();
        String afterFileName = patch.getAfterName();
        if (beforeFileName == null || patch.isNewFile()) {
            return new CheckAdded(patch);
        }
        if (afterFileName == null || patch.isDeletedFile()) {
            return new CheckDeleted(patch);
        }
        if (!beforeFileName.equals(afterFileName)) {
            return new CheckMoved(patch);
        }
        return new CheckModified(patch);
    }

    public Collection<FilePath> getToBeAdded() {
        return this.myAddedPaths;
    }

    public Collection<FilePath> getToBeDeleted() {
        return this.myDeletedPaths;
    }

    @NotNull
    public Collection<FilePatch> filterBadFileTypePatches() {
        List failedTextPatches = ContainerUtil.findAll(this.myTextPatches, textPatch -> {
            VirtualFile file2 = (VirtualFile)textPatch.getFirst();
            if (file2.isDirectory()) {
                return false;
            }
            return !this.isFileTypeOk(file2);
        });
        this.myTextPatches.removeAll(failedTextPatches);
        List list2 = ContainerUtil.map((Collection)failedTextPatches, patchInfo -> (TextFilePatch)((ApplyTextFilePatch)patchInfo.getSecond()).getPatch());
        if (list2 == null) {
            PathsVerifier.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private boolean isFileTypeOk(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            PathsVerifier.$$$reportNull$$$0(1);
        }
        if ((fileType = file2.getFileType()) == FileTypes.UNKNOWN && (fileType = FileTypeChooser.associateFileType(file2.getName())) == null) {
            PatchApplier.showError(this.myProject, "Cannot apply content for " + file2.getPresentableName() + " file from patch because its type not defined.");
            return false;
        }
        if (fileType.isBinary()) {
            PatchApplier.showError(this.myProject, "Cannot apply file " + file2.getPresentableName() + " from patch because it is binary.");
            return false;
        }
        return true;
    }

    private void addPatch(FilePatch patch, VirtualFile file2) {
        Pair patchPair = Pair.create((Object)file2, (Object)ApplyFilePatchFactory.createGeneral(patch));
        if (patch instanceof TextFilePatch) {
            this.myTextPatches.add((Pair<VirtualFile, ApplyTextFilePatch>)Pair.create((Object)file2, (Object)ApplyFilePatchFactory.create((TextFilePatch)patch)));
        } else {
            ApplyFilePatchBase applyBinaryPatch = patch instanceof BinaryFilePatch ? ApplyFilePatchFactory.create((BinaryFilePatch)patch) : ApplyFilePatchFactory.create((ShelvedBinaryFilePatch)patch);
            this.myBinaryPatches.add(Pair.create((Object)file2, (Object)applyBinaryPatch));
        }
        this.myWritableFiles.add(file2);
    }

    private static String fileNotFoundMessage(String path) {
        return VcsBundle.message((String)"cannot.find.file.to.patch", (Object[])new Object[]{path});
    }

    private static String fileAlreadyExists(String path) {
        return VcsBundle.message((String)"cannot.apply.file.already.exists", (Object[])new Object[]{path});
    }

    private void revert(String errorMessage) {
        PatchApplier.showError(this.myProject, errorMessage);
    }

    private static VirtualFile createFile(VirtualFile parent, String name2) throws IOException {
        return parent.createChildData(PatchApplier.class, name2);
    }

    private static VirtualFile moveFile(VirtualFile file2, VirtualFile newParent) throws IOException {
        file2.move(FilePatch.class, newParent);
        return file2;
    }

    @Nullable
    private VirtualFile makeSureParentPathExists(String[] pieces) throws IOException {
        VirtualFile child = this.myBaseDirectory;
        int size = pieces.length - 1;
        for (int i = 0; i < size; ++i) {
            String piece = pieces[i];
            if (StringUtil.isEmptyOrSpaces((String)piece)) continue;
            if ("..".equals(piece)) {
                child = child.getParent();
                continue;
            }
            VirtualFile nextChild = child.findChild(piece);
            if (nextChild == null) {
                nextChild = VfsUtil.createDirectories((String)(child.getPath() + '/' + piece));
                this.myCreatedDirectories.add(nextChild);
            }
            child = nextChild;
        }
        return child;
    }

    public List<Pair<VirtualFile, ApplyTextFilePatch>> getTextPatches() {
        return this.myTextPatches;
    }

    public List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> getBinaryPatches() {
        return this.myBinaryPatches;
    }

    @NotNull
    public List<VirtualFile> getWritableFiles() {
        List<VirtualFile> list2 = this.myWritableFiles;
        if (list2 == null) {
            PathsVerifier.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public void doMoveIfNeeded(VirtualFile file2) throws IOException {
        final MovedFileData movedFile = this.myMovedFiles.get(file2);
        if (movedFile != null) {
            this.myBeforePaths.add(VcsUtil.getFilePath((VirtualFile)file2));
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                public VirtualFile compute() throws IOException {
                    return movedFile.doMove();
                }
            });
        }
    }

    public void setIgnoreContentRootsCheck(boolean ignoreContentRootsCheck) {
        this.myIgnoreContentRootsCheck = ignoreContentRootsCheck;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBadFileTypePatches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFileTypeOk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelayedPrecheckContext {
        private final Map<FilePath, FilePatch> mySkipDeleted;
        private final Map<FilePath, FilePatch> myOverrideExisting;
        private final List<FilePath> myOverridenPaths;
        private final Project myProject;

        private DelayedPrecheckContext(Project project2) {
            this.myProject = project2;
            this.myOverrideExisting = new HashMap<FilePath, FilePatch>();
            this.mySkipDeleted = new HashMap<FilePath, FilePatch>();
            this.myOverridenPaths = new LinkedList<FilePath>();
        }

        public void addSkip(FilePath path, FilePatch filePatch) {
            this.mySkipDeleted.put(path, filePatch);
        }

        public void addOverrideExisting(FilePatch patch, FilePath filePath) {
            if (!this.myOverrideExisting.containsKey(filePath)) {
                this.myOverrideExisting.put(filePath, patch);
            }
        }

        public Collection<FilePatch> doDelayed() {
            LinkedList<FilePatch> result2 = new LinkedList<FilePatch>();
            if (!this.myOverrideExisting.isEmpty()) {
                String title = "Overwrite Existing Files";
                ArrayList<FilePath> files = new ArrayList<FilePath>(this.myOverrideExisting.keySet());
                Collection selected = AbstractVcsHelper.getInstance((Project)this.myProject).selectFilePathsToProcess(files, "Overwrite Existing Files", "\nThe following files should be created by patch, but they already exist.\nDo you want to overwrite them?\n", "Overwrite Existing Files", "The following file should be created by patch, but it already exists.\nDo you want to overwrite it?\n{0}", VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION, "Overwrite", "Cancel");
                if (selected != null) {
                    for (FilePath path : selected) {
                        this.myOverrideExisting.remove(path);
                    }
                }
                result2.addAll(this.myOverrideExisting.values());
                if (selected != null) {
                    this.myOverridenPaths.addAll(selected);
                }
            }
            result2.addAll(this.mySkipDeleted.values());
            return result2;
        }

        public List<FilePath> getOverridenPaths() {
            return this.myOverridenPaths;
        }

        public Collection<FilePath> getAlreadyDeletedPaths() {
            return this.mySkipDeleted.keySet();
        }
    }

    public static interface BaseMapper {
        @Nullable
        public VirtualFile getFile(FilePatch var1, String var2);

        public FilePath getPath(FilePatch var1, String var2);
    }

    private static class MovedFileData {
        private final VirtualFile myNewParent;
        private final VirtualFile myCurrent;
        private final String myNewName;

        private MovedFileData(@NotNull VirtualFile newParent, @NotNull VirtualFile current, @NotNull String newName) {
            if (newParent == null) {
                MovedFileData.$$$reportNull$$$0(0);
            }
            if (current == null) {
                MovedFileData.$$$reportNull$$$0(1);
            }
            if (newName == null) {
                MovedFileData.$$$reportNull$$$0(2);
            }
            this.myNewParent = newParent;
            this.myCurrent = current;
            this.myNewName = newName;
        }

        public VirtualFile getCurrent() {
            return this.myCurrent;
        }

        public VirtualFile getNewParent() {
            return this.myNewParent;
        }

        public String getNewName() {
            return this.myNewName;
        }

        public VirtualFile doMove() throws IOException {
            boolean needMove;
            VirtualFile oldParent = this.myCurrent.getParent();
            boolean needRename = !Comparing.equal((String)this.myCurrent.getName(), (String)this.myNewName);
            boolean bl = needMove = !this.myNewParent.equals(oldParent);
            if (needRename) {
                File oldParentFile;
                File targetAfterRenameFile;
                if (needMove && (targetAfterRenameFile = new File(oldParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)oldParent), this.myNewName)).exists() && this.myCurrent.exists()) {
                    this.performRenameWithConflicts(oldParentFile);
                    return this.myCurrent;
                }
                this.myCurrent.rename(PatchApplier.class, this.myNewName);
            }
            if (needMove) {
                this.myCurrent.move(PatchApplier.class, this.myNewParent);
            }
            return this.myCurrent;
        }

        private void performRenameWithConflicts(@NotNull File oldParent) throws IOException {
            if (oldParent == null) {
                MovedFileData.$$$reportNull$$$0(3);
            }
            File tmpFileWithUniqueName = FileUtil.createTempFile((File)oldParent, (String)"tempFileToMove", null, (boolean)false);
            File newParentFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myNewParent);
            File destFile = new File(newParentFile, tmpFileWithUniqueName.getName());
            while (destFile.exists()) {
                destFile = new File(newParentFile, FileUtil.createTempFile((File)oldParent, (String)FileUtil.getNameWithoutExtension((String)destFile.getName()), null, (boolean)false).getName());
            }
            this.myCurrent.rename(PatchApplier.class, destFile.getName());
            this.myCurrent.move(PatchApplier.class, this.myNewParent);
            this.myCurrent.rename(PatchApplier.class, this.myNewName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performRenameWithConflicts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class CheckPath {
        protected final String myBeforeName;
        protected final String myAfterName;
        protected final FilePatch myPatch;
        private String myErrorMessage;

        public CheckPath(FilePatch path) {
            this.myPatch = path;
            this.myBeforeName = path.getBeforeName();
            this.myAfterName = path.getAfterName();
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean canBeApplied(DelayedPrecheckContext context) {
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            VirtualFile afterFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myAfterName);
            return this.precheck(beforeFile, afterFile, context);
        }

        protected abstract boolean precheck(VirtualFile var1, VirtualFile var2, DelayedPrecheckContext var3);

        protected abstract boolean check() throws IOException;

        protected boolean checkExistsAndValid(VirtualFile file2, String name2) {
            if (file2 == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(name2));
                return false;
            }
            return this.checkModificationValid(file2, name2);
        }

        protected boolean checkModificationValid(VirtualFile file2, String name2) {
            if (ApplicationManager.getApplication().isUnitTestMode() && PathsVerifier.this.myIgnoreContentRootsCheck) {
                return true;
            }
            if (file2 == null || !this.inContent(file2) || PathsVerifier.this.myVcsManager.getVcsRootFor(file2) == null) {
                this.setErrorMessage("File to patch found outside content root: " + name2);
                return false;
            }
            return true;
        }

        private boolean inContent(VirtualFile file2) {
            return PathsVerifier.this.myVcsManager.isFileInContent(file2);
        }

        public FilePatch getPatch() {
            return this.myPatch;
        }
    }

    private class CheckMoved
    extends CheckPath {
        private CheckMoved(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myBeforeName));
            } else if (afterFile != null) {
                this.setErrorMessage(PathsVerifier.fileAlreadyExists(afterFile.getPath()));
            }
            return beforeFile != null && afterFile == null;
        }

        @Override
        public boolean check() throws IOException {
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile afterFileParent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (afterFileParent == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            assert (beforeFile != null);
            PathsVerifier.this.myMovedFiles.put(beforeFile, new MovedFileData(afterFileParent, beforeFile, this.myPatch.getAfterFileName()));
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            return true;
        }
    }

    private class CheckAdded
    extends CheckPath {
        private CheckAdded(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (afterFile != null) {
                context.addOverrideExisting(this.myPatch, VcsUtil.getFilePath((VirtualFile)afterFile));
            }
            return true;
        }

        @Override
        public boolean check() throws IOException {
            VirtualFile file2;
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile parent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (parent == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            String name2 = pieces[pieces.length - 1];
            File afterFile = new File(parent.getPath(), name2);
            VirtualFile virtualFile = file2 = PathsVerifier.this.myDelayedPrecheckContext.getOverridenPaths().contains(VcsUtil.getFilePath((File)afterFile)) ? parent.findChild(name2) : PathsVerifier.createFile(parent, name2);
            if (file2 == null) {
                this.setErrorMessage(PathsVerifier.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            PathsVerifier.this.myAddedPaths.add(VcsUtil.getFilePath((VirtualFile)file2));
            if (!this.checkExistsAndValid(file2, this.myAfterName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, file2);
            return true;
        }
    }

    private class CheckDeleted
    extends CheckPath {
        protected CheckDeleted(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile, DelayedPrecheckContext context) {
            if (beforeFile == null) {
                context.addSkip(PathsVerifier.this.myBaseMapper.getPath(this.myPatch, this.myBeforeName), this.myPatch);
            }
            return true;
        }

        @Override
        protected boolean check() {
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)beforeFile.getParent(), (String)beforeFile.getName(), (boolean)beforeFile.isDirectory());
            if (this.myPatch.isDeletedFile() || this.myPatch.getAfterName() == null) {
                PathsVerifier.this.myDeletedPaths.add(filePath);
            }
            PathsVerifier.this.myBeforePaths.add(filePath);
            return true;
        }
    }

    private class CheckModified
    extends CheckDeleted {
        private CheckModified(FilePatch path) {
            super(path);
        }
    }
}

