/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedElementDuplicateHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginal;

    public NamedElementDuplicateHandler(EditorActionHandler original) {
        super(true);
        this.myOriginal = original;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(1);
        }
        return this.myOriginal.isEnabled(editor, caret, dataContext);
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        Project project2 = editor.getProject();
        if (project2 != null && !editor.getSelectionModel().hasSelection()) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (file2 != null) {
                VisualPosition caret = editor.getCaretModel().getVisualPosition();
                Pair<LogicalPosition, LogicalPosition> lines2 = EditorUtil.calcSurroundingRange(editor, caret, caret);
                TextRange toDuplicate = new TextRange(editor.logicalPositionToOffset((LogicalPosition)lines2.first), editor.logicalPositionToOffset((LogicalPosition)lines2.second));
                PsiElement name2 = NamedElementDuplicateHandler.findNameIdentifier(editor, file2, toDuplicate);
                if (name2 != null && !name2.getTextRange().containsOffset(editor.getCaretModel().getOffset())) {
                    editor.getCaretModel().moveToOffset(name2.getTextOffset());
                }
            }
        }
        this.myOriginal.execute(editor, dataContext);
    }

    @Nullable
    private static PsiElement findNameIdentifier(Editor editor, PsiFile file2, TextRange toDuplicate) {
        TextRange range;
        int nonWs = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)toDuplicate.getStartOffset(), (String)"\n\t ");
        PsiElement named = null;
        for (PsiElement psi = file2.findElementAt(nonWs); psi != null && (range = psi.getTextRange()) != null && !(psi instanceof PsiFile) && toDuplicate.contains(psi.getTextRange()); psi = psi.getParent()) {
            if (!(psi instanceof PsiNameIdentifierOwner)) continue;
            named = ((PsiNameIdentifierOwner)psi).getNameIdentifier();
        }
        return named;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caret";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/actions/NamedElementDuplicateHandler";
        objectArray[2] = "isEnabledForCaret";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

