/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class FoldingAnchorsOverlayStrategy {
    private final EditorImpl myEditor;

    FoldingAnchorsOverlayStrategy(EditorImpl editor) {
        this.myEditor = editor;
    }

    @NotNull
    Collection<DisplayedFoldingAnchor> getAnchorsToDisplay(int firstVisibleOffset, int lastVisibleOffset, FoldRegion activeFoldRegion) {
        FoldRegion[] visibleFoldRegions;
        HashMap result2 = new HashMap();
        for (FoldRegion region : visibleFoldRegions = this.myEditor.getFoldingModel().fetchVisible()) {
            FoldingGroup group;
            int endOffset;
            int startOffset;
            if (!region.isValid() || (startOffset = region.getStartOffset()) > lastVisibleOffset || (endOffset = this.getEndOffset(region)) < firstVisibleOffset || !this.isFoldingPossible(startOffset, endOffset) || (group = region.getGroup()) != null && this.myEditor.getFoldingModel().getFirstRegion(group, region) != region) continue;
            int foldStart = this.myEditor.offsetToVisualLine(startOffset);
            if (!region.isExpanded()) {
                FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, 0, DisplayedFoldingAnchor.Type.COLLAPSED, activeFoldRegion);
                continue;
            }
            int foldEnd = this.myEditor.offsetToVisualLine(endOffset);
            FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_TOP, activeFoldRegion);
            FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldEnd, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_BOTTOM, activeFoldRegion);
        }
        Collection<DisplayedFoldingAnchor> collection = result2.values();
        if (collection == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static void tryAdding(@NotNull Map<Integer, DisplayedFoldingAnchor> resultsMap, @NotNull FoldRegion region, int visualLine, int visualHeight, @NotNull DisplayedFoldingAnchor.Type type2, FoldRegion activeRegion) {
        DisplayedFoldingAnchor prev;
        if (resultsMap == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(1);
        }
        if (region == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(3);
        }
        if ((prev = resultsMap.get(visualLine)) != null) {
            if (prev.foldRegion == activeRegion) {
                return;
            }
            if (region != activeRegion && prev.foldRegionVisualLines < visualHeight) {
                return;
            }
        }
        resultsMap.put(visualLine, new DisplayedFoldingAnchor(region, visualLine, visualHeight, type2));
    }

    private int getEndOffset(@NotNull FoldRegion foldRange) {
        FoldingGroup group;
        if (foldRange == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(4);
        }
        return (group = foldRange.getGroup()) == null ? foldRange.getEndOffset() : this.myEditor.getFoldingModel().getEndOffset(group);
    }

    private boolean isFoldingPossible(int startOffset, int endOffset) {
        DocumentEx document = this.myEditor.getDocument();
        if (startOffset >= document.getTextLength()) {
            return false;
        }
        int endOffsetToUse = Math.min(endOffset, document.getTextLength());
        if (endOffsetToUse <= startOffset) {
            return false;
        }
        if (document.getLineNumber(startOffset) != document.getLineNumber(endOffsetToUse)) {
            return true;
        }
        return this.myEditor.getSettings().isAllowSingleLogicalLineFolding() && !this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffsetToUse).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingAnchorsOverlayStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultsMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorsToDisplay";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingAnchorsOverlayStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryAdding";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

