/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiBasedStripTrailingSpacesFilter
implements StripTrailingSpacesFilter {
    @NotNull
    private final BitSet myDisabledLinesBitSet;
    @NotNull
    private final Document myDocument;
    private static Logger LOG = Logger.getInstance(PsiBasedStripTrailingSpacesFilter.class);

    protected PsiBasedStripTrailingSpacesFilter(@NotNull Document document) {
        if (document == null) {
            PsiBasedStripTrailingSpacesFilter.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
        this.myDisabledLinesBitSet = new BitSet(document.getLineCount());
    }

    public boolean isStripSpacesAllowedForLine(int line) {
        return !this.myDisabledLinesBitSet.get(line);
    }

    protected abstract void process(@NotNull PsiFile var1);

    @Nullable
    public static Language getDocumentLanguage(@NotNull Document document) {
        FileDocumentManager manager;
        VirtualFile file2;
        if (document == null) {
            PsiBasedStripTrailingSpacesFilter.$$$reportNull$$$0(1);
        }
        if ((file2 = (manager = FileDocumentManager.getInstance()).getFile(document)) != null && file2.isValid()) {
            return LanguageUtil.getFileLanguage((VirtualFile)file2);
        }
        return null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            PsiBasedStripTrailingSpacesFilter.$$$reportNull$$$0(2);
        }
        if (project2 != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            if (documentManager.isCommitted(document)) {
                return documentManager.getCachedPsiFile(document);
            }
        } else {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            LOG.warn("No current project is given, trailing spaces will be stripped later (postponed). File: " + (virtualFile != null ? virtualFile.getCanonicalPath() : "undefined"));
        }
        return null;
    }

    protected final void disableRange(@NotNull TextRange range, boolean includeEndLine) {
        if (range == null) {
            PsiBasedStripTrailingSpacesFilter.$$$reportNull$$$0(3);
        }
        int startLine = this.myDocument.getLineNumber(range.getStartOffset());
        int endLine = this.myDocument.getLineNumber(range.getEndOffset());
        if (includeEndLine) {
            ++endLine;
        }
        this.myDisabledLinesBitSet.set(startLine, endLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "disableRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class Factory
    extends StripTrailingSpacesFilterFactory {
        @NotNull
        public final StripTrailingSpacesFilter createFilter(@Nullable Project project2, @NotNull Document document) {
            Language language;
            if (document == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if ((language = PsiBasedStripTrailingSpacesFilter.getDocumentLanguage(document)) != null && this.isApplicableTo(language)) {
                PsiFile psiFile = PsiBasedStripTrailingSpacesFilter.getPsiFile(project2, document);
                if (psiFile != null) {
                    PsiBasedStripTrailingSpacesFilter filter2 = this.createFilter(document);
                    filter2.process(psiFile);
                    PsiBasedStripTrailingSpacesFilter psiBasedStripTrailingSpacesFilter = filter2;
                    if (psiBasedStripTrailingSpacesFilter == null) {
                        Factory.$$$reportNull$$$0(1);
                    }
                    return psiBasedStripTrailingSpacesFilter;
                }
                StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.POSTPONED;
                if (stripTrailingSpacesFilter == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return stripTrailingSpacesFilter;
            }
            StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.ALL_LINES;
            if (stripTrailingSpacesFilter == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return stripTrailingSpacesFilter;
        }

        @NotNull
        protected abstract PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document var1);

        protected abstract boolean isApplicableTo(@NotNull Language var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

